/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.zaasclient.service.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import lombok.Generated;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.zowe.apiml.zaasclient.config.ConfigProperties;
import org.zowe.apiml.zaasclient.exception.ZaasConfigurationErrorCodes;
import org.zowe.apiml.zaasclient.exception.ZaasConfigurationException;
import org.zowe.apiml.zaasclient.service.internal.CloseableClientProvider;

class HttpsClientProvider
implements CloseableClientProvider {
    private final RequestConfig requestConfig;
    public static final String SAFKEYRING = "safkeyring";
    private TrustManagerFactory tmf;
    private KeyManagerFactory kmf;
    private final String keyStorePassword;
    private final String keyStoreType;
    private String keyStorePath;

    public HttpsClientProvider(ConfigProperties configProperties) throws ZaasConfigurationException {
        this.requestConfig = this.buildCustomRequestConfig();
        if (configProperties.getTrustStorePath() == null) {
            throw new ZaasConfigurationException(ZaasConfigurationErrorCodes.TRUST_STORE_NOT_PROVIDED);
        }
        this.initializeTrustManagerFactory(configProperties.getTrustStorePath(), configProperties.getTrustStoreType(), configProperties.getTrustStorePassword());
        this.keyStorePath = configProperties.getKeyStorePath();
        this.keyStorePassword = configProperties.getKeyStorePassword();
        this.keyStoreType = configProperties.getKeyStoreType();
    }

    @Override
    public CloseableHttpClient getHttpsClientWithTrustStore() throws ZaasConfigurationException {
        return this.sharedHttpClientConfiguration(this.getSSLContext()).build();
    }

    @Override
    public CloseableHttpClient getHttpsClientWithTrustStore(BasicCookieStore cookieStore) throws ZaasConfigurationException {
        return this.sharedHttpClientConfiguration(this.getSSLContext()).setDefaultCookieStore((CookieStore)cookieStore).build();
    }

    @Override
    public CloseableHttpClient getHttpsClientWithKeyStoreAndTrustStore() throws ZaasConfigurationException {
        if (this.keyStorePath == null) {
            throw new ZaasConfigurationException(ZaasConfigurationErrorCodes.KEY_STORE_NOT_PROVIDED);
        }
        if (this.kmf == null) {
            this.initializeKeyStoreManagerFactory();
        }
        return this.sharedHttpClientConfiguration(this.getSSLContext()).build();
    }

    private void initializeTrustManagerFactory(String trustStorePath, String trustStoreType, String trustStorePassword) throws ZaasConfigurationException {
        try {
            this.tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore trustStore = this.getKeystore(trustStorePath, trustStoreType, trustStorePassword);
            this.tmf.init(trustStore);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new ZaasConfigurationException(ZaasConfigurationErrorCodes.WRONG_CRYPTO_CONFIGURATION, (Throwable)e);
        }
        catch (IOException e) {
            throw new ZaasConfigurationException(ZaasConfigurationErrorCodes.IO_CONFIGURATION_ISSUE, (Throwable)e);
        }
    }

    private void initializeKeyStoreManagerFactory() throws ZaasConfigurationException {
        try {
            this.kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = this.getKeystore(this.keyStorePath, this.keyStoreType, this.keyStorePassword);
            this.kmf.init(keyStore, this.keyStorePassword.toCharArray());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new ZaasConfigurationException(ZaasConfigurationErrorCodes.WRONG_CRYPTO_CONFIGURATION, (Throwable)e);
        }
        catch (IOException e) {
            throw new ZaasConfigurationException(ZaasConfigurationErrorCodes.IO_CONFIGURATION_ISSUE, (Throwable)e);
        }
    }

    private KeyStore getKeystore(String uri, String keyStoreType, String storePassword) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        InputStream correctInStream = this.getCorrectInputStream(uri);
        keyStore.load(correctInStream, storePassword.toCharArray());
        return keyStore;
    }

    private InputStream getCorrectInputStream(String uri) throws IOException {
        if (uri.startsWith("safkeyring:////")) {
            URL url = new URL(HttpsClientProvider.replaceFourSlashes(uri));
            return url.openStream();
        }
        return new FileInputStream(new File(uri));
    }

    public static String replaceFourSlashes(String storeUri) {
        return storeUri == null ? null : storeUri.replaceFirst("////", "//");
    }

    private SSLContext getSSLContext() throws ZaasConfigurationException {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(this.kmf != null ? this.kmf.getKeyManagers() : null, this.tmf.getTrustManagers(), new SecureRandom());
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new ZaasConfigurationException(ZaasConfigurationErrorCodes.WRONG_CRYPTO_CONFIGURATION, (Throwable)e);
        }
    }

    private HttpClientBuilder sharedHttpClientConfiguration(SSLContext sslContext) {
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultRequestConfig(this.requestConfig).setMaxConnTotal(9).setMaxConnPerRoute(3);
    }

    private RequestConfig buildCustomRequestConfig() {
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectionRequestTimeout(10000);
        builder.setSocketTimeout(10000);
        builder.setConnectTimeout(10000);
        return builder.build();
    }

    @Generated
    public HttpsClientProvider(RequestConfig requestConfig, TrustManagerFactory tmf, KeyManagerFactory kmf, String keyStorePassword, String keyStoreType, String keyStorePath) {
        this.requestConfig = requestConfig;
        this.tmf = tmf;
        this.kmf = kmf;
        this.keyStorePassword = keyStorePassword;
        this.keyStoreType = keyStoreType;
        this.keyStorePath = keyStorePath;
    }
}

