/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.zaasclient.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.zowe.apiml.zaasclient.config.ConfigProperties;
import org.zowe.apiml.zaasclient.exception.ZaasConfigurationException;
import org.zowe.apiml.zaasclient.service.ZaasClient;
import org.zowe.apiml.zaasclient.service.internal.ZaasClientImpl;

public class DefaultZaasClientConfiguration {
    @Value(value="${apiml.service.hostname}")
    private String host;
    @Value(value="${apiml.service.customMetadata.apiml.gatewayPort}")
    private String port;
    @Value(value="${apiml.service.customMetadata.apiml.gatewayAuthEndpoint}")
    private String baseUrl;
    @Value(value="${apiml.service.ssl.keyStore}")
    private String keyStorePath;
    @Value(value="${apiml.service.ssl.keyStorePassword}")
    private char[] keyStorePassword;
    @Value(value="${apiml.service.ssl.keyStoreType}")
    private String keyStoreType;
    @Value(value="${apiml.service.ssl.trustStore}")
    private String trustStorePath;
    @Value(value="${apiml.service.ssl.trustStorePassword}")
    private char[] trustStorePassword;
    @Value(value="${apiml.service.ssl.trustStoreType}")
    private String trustStoreType;

    @Bean
    public ConfigProperties getConfigProperties() {
        ConfigProperties configProperties = new ConfigProperties();
        configProperties.setApimlHost(this.host);
        configProperties.setApimlPort(this.port);
        configProperties.setApimlBaseUrl(this.baseUrl);
        configProperties.setKeyStorePath(this.keyStorePath);
        configProperties.setKeyStorePassword(this.keyStorePassword);
        configProperties.setKeyStoreType(this.keyStoreType);
        configProperties.setTrustStorePath(this.trustStorePath);
        configProperties.setTrustStorePassword(this.trustStorePassword);
        configProperties.setTrustStoreType(this.trustStoreType);
        return configProperties;
    }

    @Bean
    public ZaasClient zaasClient() throws ZaasConfigurationException {
        return new ZaasClientImpl(this.getConfigProperties());
    }
}

