/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.client.token;

import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import org.zowe.apiml.security.client.service.GatewaySecurity;
import org.zowe.apiml.security.common.token.QueryResponse;
import org.zowe.apiml.security.common.token.TokenAuthentication;

@Component
@ConditionalOnMissingBean(name={"modulithConfig"})
public class GatewayTokenProvider
implements AuthenticationProvider {
    private final GatewaySecurity gatewaySecurity;

    public Authentication authenticate(Authentication authentication) {
        TokenAuthentication tokenAuthentication = (TokenAuthentication)authentication;
        QueryResponse queryResponse = tokenAuthentication.getType() == TokenAuthentication.Type.OIDC ? this.gatewaySecurity.verifyOidc(tokenAuthentication.getCredentials()) : this.gatewaySecurity.query(tokenAuthentication.getCredentials());
        TokenAuthentication validTokenAuthentication = new TokenAuthentication(queryResponse.getUserId(), tokenAuthentication.getCredentials(), tokenAuthentication.getType());
        validTokenAuthentication.setAuthenticated(true);
        return validTokenAuthentication;
    }

    public boolean supports(Class<?> authentication) {
        return TokenAuthentication.class.isAssignableFrom(authentication);
    }

    @Generated
    public GatewayTokenProvider(GatewaySecurity gatewaySecurity) {
        this.gatewaySecurity = gatewaySecurity;
    }
}

