/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.client.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Service;
import org.zowe.apiml.product.gateway.GatewayClient;
import org.zowe.apiml.product.gateway.GatewayConfigProperties;
import org.zowe.apiml.security.client.handler.RestResponseHandler;
import org.zowe.apiml.security.common.config.AuthConfigurationProperties;
import org.zowe.apiml.security.common.error.ErrorType;
import org.zowe.apiml.security.common.token.QueryResponse;

@Service
public class GatewaySecurityService {
    private static final String MESSAGE_KEY_STRING = "messageKey\":\"";
    private final GatewayClient gatewayClient;
    private final AuthConfigurationProperties authConfigurationProperties;
    private final CloseableHttpClient closeableHttpClient;
    private final RestResponseHandler responseHandler;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public Optional<String> login(String username, String password, String newPassword) {
        GatewayConfigProperties gatewayConfigProperties = this.gatewayClient.getGatewayConfigProperties();
        String uri = String.format("%s://%s%s", gatewayConfigProperties.getScheme(), gatewayConfigProperties.getHostname(), this.authConfigurationProperties.getGatewayLoginEndpoint());
        ObjectNode loginRequest = this.objectMapper.createObjectNode();
        loginRequest.put("username", username);
        loginRequest.put("password", password);
        if (StringUtils.isNotEmpty((CharSequence)newPassword)) {
            loginRequest.put("newPassword", newPassword);
        }
        try {
            int statusCode;
            HttpPost post = new HttpPost(uri);
            String json = this.objectMapper.writeValueAsString((Object)loginRequest);
            post.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
            CloseableHttpResponse response = this.closeableHttpClient.execute((HttpUriRequest)post);
            int n = statusCode = response.getStatusLine() != null ? response.getStatusLine().getStatusCode() : 0;
            if (statusCode < 200 || statusCode >= 300) {
                HttpEntity responseEntity = response.getEntity();
                String responseBody = null;
                if (responseEntity != null) {
                    responseBody = EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8);
                }
                ErrorType errorType = this.getErrorType(responseBody);
                this.responseHandler.handleErrorType(response, errorType, "Cannot access Gateway service. Uri '{}' returned: {}", uri);
                return Optional.empty();
            }
            return this.extractToken(response.getFirstHeader("Set-Cookie").getValue());
        }
        catch (IOException e) {
            this.responseHandler.handleException(e);
            return Optional.empty();
        }
    }

    public QueryResponse query(String token) {
        GatewayConfigProperties gatewayConfigProperties = this.gatewayClient.getGatewayConfigProperties();
        String uri = String.format("%s://%s%s", gatewayConfigProperties.getScheme(), gatewayConfigProperties.getHostname(), this.authConfigurationProperties.getGatewayQueryEndpoint());
        String cookie = String.format("%s=%s", this.authConfigurationProperties.getCookieProperties().getCookieName(), token);
        try {
            int statusCode;
            HttpGet get = new HttpGet(uri);
            get.addHeader("Cookie", cookie);
            CloseableHttpResponse response = this.closeableHttpClient.execute((HttpUriRequest)get);
            HttpEntity responseEntity = response.getEntity();
            String responseBody = null;
            if (responseEntity != null) {
                responseBody = EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8);
            }
            int n = statusCode = response.getStatusLine() != null ? response.getStatusLine().getStatusCode() : 0;
            if (statusCode < 200 || statusCode >= 300) {
                ErrorType errorType = this.getErrorType(responseBody);
                this.responseHandler.handleErrorType(response, errorType, "Cannot access Gateway service. Uri '{}' returned: {}", uri);
                return null;
            }
            return (QueryResponse)this.objectMapper.readValue(responseBody, QueryResponse.class);
        }
        catch (IOException e) {
            this.responseHandler.handleException(e);
            return null;
        }
    }

    private ErrorType getErrorType(String detailMessage) {
        if (detailMessage == null) {
            return ErrorType.AUTH_GENERAL;
        }
        int indexOfMessageKey = detailMessage.indexOf(MESSAGE_KEY_STRING);
        if (indexOfMessageKey < 0) {
            return ErrorType.AUTH_GENERAL;
        }
        String messageKeyToEndOfExceptionMessage = detailMessage.substring(indexOfMessageKey + MESSAGE_KEY_STRING.length());
        String messageKey = messageKeyToEndOfExceptionMessage.substring(0, messageKeyToEndOfExceptionMessage.indexOf("\""));
        try {
            return ErrorType.fromMessageKey((String)messageKey);
        }
        catch (IllegalArgumentException e) {
            return ErrorType.AUTH_GENERAL;
        }
    }

    private Optional<String> extractToken(String cookies) {
        String cookieName = this.authConfigurationProperties.getCookieProperties().getCookieName();
        if (cookies == null || cookies.isEmpty() || !cookies.contains(cookieName)) {
            return Optional.empty();
        }
        int end = cookies.indexOf(59);
        String cookie = end > 0 ? cookies.substring(0, end) : cookies;
        return Optional.of(cookie.replace(cookieName + "=", ""));
    }

    @Generated
    public GatewaySecurityService(GatewayClient gatewayClient, AuthConfigurationProperties authConfigurationProperties, CloseableHttpClient closeableHttpClient, RestResponseHandler responseHandler) {
        this.gatewayClient = gatewayClient;
        this.authConfigurationProperties = authConfigurationProperties;
        this.closeableHttpClient = closeableHttpClient;
        this.responseHandler = responseHandler;
    }
}

