/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.client.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Service;
import org.zowe.apiml.product.gateway.GatewayClient;
import org.zowe.apiml.product.gateway.GatewayConfigProperties;
import org.zowe.apiml.security.client.handler.RestResponseHandler;
import org.zowe.apiml.security.common.config.AuthConfigurationProperties;
import org.zowe.apiml.security.common.error.ErrorType;
import org.zowe.apiml.security.common.token.QueryResponse;

@Service
public class GatewaySecurityService {
    private static final String MESSAGE_KEY_STRING = "messageKey\":\"";
    private final GatewayClient gatewayClient;
    private final AuthConfigurationProperties authConfigurationProperties;
    private final CloseableHttpClient closeableHttpClient;
    private final RestResponseHandler responseHandler;
    private final ObjectMapper objectMapper = new ObjectMapper();

    /*
     * Exception decompiling
     */
    public Optional<String> login(String username, char[] password, char[] newPassword) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QueryResponse query(String token) {
        GatewayConfigProperties gatewayConfigProperties = this.gatewayClient.getGatewayConfigProperties();
        String uri = String.format("%s://%s%s", gatewayConfigProperties.getScheme(), gatewayConfigProperties.getHostname(), this.authConfigurationProperties.getGatewayQueryEndpoint());
        String cookie = String.format("%s=%s", this.authConfigurationProperties.getCookieProperties().getCookieName(), token);
        HttpGet get = new HttpGet(uri);
        get.addHeader("Cookie", cookie);
        try (CloseableHttpResponse response = this.closeableHttpClient.execute((HttpUriRequest)get);){
            int statusCode;
            HttpEntity responseEntity = response.getEntity();
            String responseBody = null;
            if (responseEntity != null) {
                responseBody = EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8);
            }
            int n = statusCode = response.getStatusLine() != null ? response.getStatusLine().getStatusCode() : 0;
            if (statusCode < 200 || statusCode >= 300) {
                ErrorType errorType = this.getErrorType(responseBody);
                this.responseHandler.handleErrorType(response, errorType, "Cannot access Gateway service. Uri '{}' returned: {}", uri);
                QueryResponse queryResponse2 = null;
                return queryResponse2;
            }
            QueryResponse queryResponse = (QueryResponse)this.objectMapper.readValue(responseBody, QueryResponse.class);
            return queryResponse;
        }
        catch (IOException e) {
            this.responseHandler.handleException(e);
            return null;
        }
    }

    private ErrorType getErrorType(String detailMessage) {
        if (detailMessage == null) {
            return ErrorType.AUTH_GENERAL;
        }
        int indexOfMessageKey = detailMessage.indexOf(MESSAGE_KEY_STRING);
        if (indexOfMessageKey < 0) {
            return ErrorType.AUTH_GENERAL;
        }
        String messageKeyToEndOfExceptionMessage = detailMessage.substring(indexOfMessageKey + MESSAGE_KEY_STRING.length());
        String messageKey = messageKeyToEndOfExceptionMessage.substring(0, messageKeyToEndOfExceptionMessage.indexOf("\""));
        try {
            return ErrorType.fromMessageKey((String)messageKey);
        }
        catch (IllegalArgumentException e) {
            return ErrorType.AUTH_GENERAL;
        }
    }

    private Optional<String> extractToken(String cookies) {
        String cookieName = this.authConfigurationProperties.getCookieProperties().getCookieName();
        if (cookies == null || cookies.isEmpty() || !cookies.contains(cookieName)) {
            return Optional.empty();
        }
        int end = cookies.indexOf(59);
        String cookie = end > 0 ? cookies.substring(0, end) : cookies;
        return Optional.of(cookie.replace(cookieName + "=", ""));
    }

    @Generated
    public GatewaySecurityService(GatewayClient gatewayClient, AuthConfigurationProperties authConfigurationProperties, CloseableHttpClient closeableHttpClient, RestResponseHandler responseHandler) {
        this.gatewayClient = gatewayClient;
        this.authConfigurationProperties = authConfigurationProperties;
        this.closeableHttpClient = closeableHttpClient;
        this.responseHandler = responseHandler;
    }
}

