/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.client.login;

import java.util.Optional;
import lombok.Generated;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import org.zowe.apiml.security.client.service.GatewaySecurityService;
import org.zowe.apiml.security.common.login.LoginRequest;
import org.zowe.apiml.security.common.token.TokenAuthentication;

@Component
public class GatewayLoginProvider
implements AuthenticationProvider {
    private final GatewaySecurityService gatewaySecurityService;

    public Authentication authenticate(Authentication authentication) {
        String password;
        String username = authentication.getPrincipal().toString();
        String newPassword = null;
        if (authentication.getCredentials() instanceof LoginRequest) {
            LoginRequest credentials = (LoginRequest)authentication.getCredentials();
            password = credentials.getPassword();
            newPassword = LoginRequest.getNewPassword((Authentication)authentication);
        } else {
            password = (String)authentication.getCredentials();
        }
        Optional<String> token = this.gatewaySecurityService.login(username, password, newPassword);
        if (!token.isPresent()) {
            throw new BadCredentialsException("Invalid Credentials");
        }
        TokenAuthentication tokenAuthentication = new TokenAuthentication(username, token.get());
        tokenAuthentication.setAuthenticated(true);
        return tokenAuthentication;
    }

    public boolean supports(Class<?> auth) {
        return auth.equals(UsernamePasswordAuthenticationToken.class);
    }

    @Generated
    public GatewayLoginProvider(GatewaySecurityService gatewaySecurityService) {
        this.gatewaySecurityService = gatewaySecurityService;
    }
}

