/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.client.handler;

import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResourceAccessException;
import org.zowe.apiml.product.gateway.GatewayNotAvailableException;
import org.zowe.apiml.security.common.auth.saf.PlatformReturned;
import org.zowe.apiml.security.common.error.AuthMethodNotSupportedException;
import org.zowe.apiml.security.common.error.ErrorType;
import org.zowe.apiml.security.common.error.ServiceNotAccessibleException;
import org.zowe.apiml.security.common.error.ZosAuthenticationException;
import org.zowe.apiml.security.common.token.InvalidTokenTypeException;
import org.zowe.apiml.security.common.token.TokenNotProvidedException;
import org.zowe.apiml.security.common.token.TokenNotValidException;

@Component
public class RestResponseHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestResponseHandler.class);

    public void handleBadResponse(@NotNull Exception exception, ErrorType errorType, String genericLogErrorMessage, Object ... logParameters) {
        if (exception instanceof HttpClientErrorException) {
            this.handleHttpClientError(exception, errorType, genericLogErrorMessage, logParameters);
        } else {
            if (exception instanceof ResourceAccessException) {
                throw new GatewayNotAvailableException(ErrorType.GATEWAY_NOT_AVAILABLE.getDefaultMessage(), (Throwable)exception);
            }
            if (exception instanceof HttpServerErrorException) {
                HttpServerErrorException hseException = (HttpServerErrorException)((Object)exception);
                if (hseException.getStatusCode().equals((Object)HttpStatus.SERVICE_UNAVAILABLE) || hseException.getStatusCode().equals((Object)HttpStatus.INTERNAL_SERVER_ERROR)) {
                    throw new ServiceNotAccessibleException(ErrorType.SERVICE_UNAVAILABLE.getDefaultMessage(), (Throwable)exception);
                }
                throw hseException;
            }
        }
    }

    private void handleHttpClientError(@NotNull Exception exception, ErrorType errorType, String genericLogErrorMessage, Object ... logParameters) {
        HttpClientErrorException hceException = (HttpClientErrorException)((Object)exception);
        switch (hceException.getStatusCode()) {
            case UNAUTHORIZED: {
                if (errorType != null) {
                    if (errorType.equals((Object)ErrorType.BAD_CREDENTIALS)) {
                        throw new BadCredentialsException(errorType.getDefaultMessage(), (Throwable)exception);
                    }
                    if (errorType.equals((Object)ErrorType.TOKEN_NOT_VALID)) {
                        throw new TokenNotValidException(errorType.getDefaultMessage(), (Throwable)exception);
                    }
                    if (errorType.equals((Object)ErrorType.TOKEN_NOT_PROVIDED)) {
                        throw new TokenNotProvidedException(errorType.getDefaultMessage());
                    }
                    if (errorType.equals((Object)ErrorType.INVALID_TOKEN_TYPE)) {
                        throw new InvalidTokenTypeException(errorType.getDefaultMessage());
                    }
                    if (errorType.equals((Object)ErrorType.USER_SUSPENDED)) {
                        throw new ZosAuthenticationException(PlatformReturned.builder().errno(163).errnoMsg("org.zowe.apiml.security.platform.errno.EMVSSAFEXTRERR").build());
                    }
                    if (errorType.equals((Object)ErrorType.NEW_PASSWORD_INVALID)) {
                        throw new ZosAuthenticationException(PlatformReturned.builder().errno(169).errnoMsg("org.zowe.apiml.security.platform.errno.EMVSPASSWORD").build());
                    }
                    if (errorType.equals((Object)ErrorType.PASSWORD_EXPIRED)) {
                        throw new ZosAuthenticationException(PlatformReturned.builder().errno(168).errnoMsg("org.zowe.apiml.security.platform.errno.EMVSEXPIRE").build());
                    }
                }
                throw new BadCredentialsException(ErrorType.BAD_CREDENTIALS.getDefaultMessage(), (Throwable)exception);
            }
            case BAD_REQUEST: {
                throw new AuthenticationCredentialsNotFoundException(ErrorType.AUTH_CREDENTIALS_NOT_FOUND.getDefaultMessage(), (Throwable)exception);
            }
            case METHOD_NOT_ALLOWED: {
                throw new AuthMethodNotSupportedException(ErrorType.AUTH_METHOD_NOT_SUPPORTED.getDefaultMessage());
            }
        }
        this.addDebugMessage(exception, genericLogErrorMessage, logParameters);
        throw new AuthenticationServiceException(ErrorType.AUTH_GENERAL.getDefaultMessage(), (Throwable)exception);
    }

    private void addDebugMessage(Exception exception, String genericLogErrorMessage, Object ... logParameters) {
        if (genericLogErrorMessage != null) {
            if (logParameters.length > 0) {
                log.debug(genericLogErrorMessage, logParameters);
            } else {
                log.debug(genericLogErrorMessage, (Throwable)exception);
            }
        }
    }
}

