/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.enable.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.zowe.apiml.eurekaservice.client.ApiMediationClient;
import org.zowe.apiml.eurekaservice.client.EurekaClientConfigProvider;
import org.zowe.apiml.eurekaservice.client.EurekaClientProvider;
import org.zowe.apiml.eurekaservice.client.config.ApiMediationServiceConfig;
import org.zowe.apiml.eurekaservice.client.impl.ApiMediationClientImpl;
import org.zowe.apiml.eurekaservice.client.impl.DiscoveryClientProvider;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.message.yaml.YamlMessageService;
import org.zowe.apiml.message.yaml.YamlMessageServiceInstance;
import org.zowe.apiml.product.logging.annotations.EnableApimlLogger;

@Configuration
@ComponentScan(value={"org.zowe.apiml.enable"})
@EnableApimlLogger
public class EnableApiDiscoveryConfig {
    @Bean
    public MessageService messageServiceDiscovery() {
        YamlMessageService messageService = YamlMessageServiceInstance.getInstance();
        messageService.loadMessages("/onboarding-enabler-spring-messages.yml");
        return messageService;
    }

    @ConditionalOnMissingBean(value={EurekaClientProvider.class})
    @Bean
    public ApiMediationClient defaultApiMediationClient() {
        return new ApiMediationClientImpl();
    }

    @ConditionalOnBean(value={EurekaClientProvider.class})
    @Bean
    public ApiMediationClient apiMediationClient(EurekaClientProvider eurekaClientProvider) {
        if (eurekaClientProvider == null) {
            return new ApiMediationClientImpl();
        }
        return new ApiMediationClientImpl(eurekaClientProvider);
    }

    @ConditionalOnBean(name={"EurekaClientProvider.class, EurekaClientConfigProvider.class"})
    @Bean
    public ApiMediationClient apiMediationClient(EurekaClientProvider eurekaClientProvider, EurekaClientConfigProvider eurekaClientConfigProvider) {
        if (eurekaClientProvider != null) {
            if (eurekaClientConfigProvider != null) {
                return new ApiMediationClientImpl(eurekaClientProvider, eurekaClientConfigProvider);
            }
            return new ApiMediationClientImpl(eurekaClientProvider);
        }
        if (eurekaClientConfigProvider != null) {
            return new ApiMediationClientImpl((EurekaClientProvider)new DiscoveryClientProvider(), eurekaClientConfigProvider);
        }
        return new ApiMediationClientImpl();
    }

    @ConfigurationProperties(prefix="apiml.service", ignoreInvalidFields=true)
    @Bean
    public ApiMediationServiceConfig apiMediationServiceConfig() {
        return new ApiMediationServiceConfig();
    }
}

