/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.register;

import io.micronaut.context.annotation.Value;
import io.micronaut.context.event.ShutdownEvent;
import io.micronaut.context.event.StartupEvent;
import io.micronaut.retry.annotation.Retryable;
import io.micronaut.runtime.event.annotation.EventListener;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.zowe.apiml.config.DiscoveryClientConfig;
import org.zowe.apiml.eurekaservice.client.ApiMediationClient;
import org.zowe.apiml.eurekaservice.client.config.ApiMediationServiceConfig;
import org.zowe.apiml.exception.ServiceDefinitionException;

@Singleton
public class ApiMlRegistrar {
    @Inject
    DiscoveryClientConfig config;
    @Value(value="${apiml:enabled:true}")
    boolean apimlEnabled;
    @Inject
    ApiMediationClient apiMlClient;

    @EventListener
    @Retryable
    void onStartupEvent(StartupEvent event) throws ServiceDefinitionException {
        this.apiMlClient.register((ApiMediationServiceConfig)this.config);
    }

    @EventListener
    void onShutDownEvent(ShutdownEvent event) {
        this.apiMlClient.unregister();
    }
}

