/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.eurekaservice.client.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.zowe.apiml.eurekaservice.client.config.ApiMediationServiceConfig;
import org.zowe.apiml.exception.ServiceDefinitionException;
import org.zowe.apiml.util.FileUtils;
import org.zowe.apiml.util.ObjectUtil;
import org.zowe.apiml.util.StringUtils;
import org.zowe.apiml.util.UrlUtils;

public class ApiMediationServiceConfigReader {
    public static final String APIML_DEFAULT_CONFIG = "apiml.config.location";
    public static final String APIML_ADDITIONAL_CONFIG = "apiml.config.additional-location";
    private static final String DEFAULT_CONFIGURATION_FILE_NAME = "/service-configuration.yml";
    private final ObjectMapper objectMapper;
    private final ThreadLocal<Map<String, String>> threadConfigurationContext = ThreadLocal.withInitial(HashMap::new);

    public ApiMediationServiceConfigReader() {
        this.objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.setDefaultMergeable(Boolean.valueOf(true));
        this.objectMapper.setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_NULL, (JsonInclude.Include)JsonInclude.Include.NON_ABSENT));
    }

    public ApiMediationServiceConfig mergeConfigurations(ApiMediationServiceConfig defaultConfiguration, ApiMediationServiceConfig additionalConfiguration) {
        Map defaultConfigPropertiesMap = (Map)this.objectMapper.convertValue((Object)defaultConfiguration, Map.class);
        Map additionalConfigPropertiesMap = (Map)this.objectMapper.convertValue((Object)additionalConfiguration, Map.class);
        Map config = ObjectUtil.mergeConfigurations((Map)defaultConfigPropertiesMap, (Map)additionalConfigPropertiesMap);
        return (ApiMediationServiceConfig)this.objectMapper.convertValue((Object)config, ApiMediationServiceConfig.class);
    }

    public ApiMediationServiceConfig loadConfiguration(String internalConfigurationFileName) throws ServiceDefinitionException {
        return this.loadConfiguration(internalConfigurationFileName, null, false);
    }

    public ApiMediationServiceConfig loadConfiguration(String internalConfigFileName, String externalizedConfigFileName) throws ServiceDefinitionException {
        return this.loadConfiguration(internalConfigFileName, externalizedConfigFileName, false);
    }

    private ApiMediationServiceConfig loadConfiguration(String internalConfigFileName, String externalizedConfigFileName, boolean isInitialized) throws ServiceDefinitionException {
        if (!isInitialized) {
            this.initializeContextMap();
            this.setApiMlSystemProperties();
        }
        if (internalConfigFileName == null) {
            internalConfigFileName = DEFAULT_CONFIGURATION_FILE_NAME;
        }
        ApiMediationServiceConfig serviceConfig = this.buildConfiguration(internalConfigFileName);
        if (externalizedConfigFileName != null) {
            ApiMediationServiceConfig externalizedConfig = this.buildConfiguration(externalizedConfigFileName);
            ApiMediationServiceConfig mergedConfig = null;
            if (externalizedConfig != null) {
                mergedConfig = this.mergeConfigurations(serviceConfig, externalizedConfig);
            }
            if (mergedConfig != null) {
                serviceConfig = mergedConfig;
            }
        }
        this.setServiceIpAddress(serviceConfig);
        return serviceConfig;
    }

    private void setServiceIpAddress(ApiMediationServiceConfig serviceConfig) throws ServiceDefinitionException {
        if (serviceConfig != null && serviceConfig.getServiceIpAddress() == null) {
            String urlString = serviceConfig.getBaseUrl();
            try {
                serviceConfig.setServiceIpAddress(UrlUtils.getIpAddressFromUrl((String)urlString));
            }
            catch (MalformedURLException e) {
                throw new ServiceDefinitionException(String.format("%s is not a valid URL.", urlString), (Throwable)e);
            }
            catch (UnknownHostException e) {
                throw new ServiceDefinitionException(String.format("URL %s contains unknown hostname.", urlString), (Throwable)e);
            }
        }
    }

    public ApiMediationServiceConfig buildConfiguration(String fileName) throws ServiceDefinitionException {
        return this.buildConfiguration(fileName, this.threadConfigurationContext.get());
    }

    public ApiMediationServiceConfig buildConfiguration(String fileName, Map<String, String> properties) throws ServiceDefinitionException {
        if (fileName == null) {
            return null;
        }
        String configData = null;
        try {
            configData = FileUtils.readConfigurationFile((String)fileName);
        }
        catch (IOException e) {
            throw new ServiceDefinitionException(String.format("Configuration data can't be read from file %s.", fileName), (Throwable)e);
        }
        configData = StringUtils.resolveExpressions((String)configData, properties);
        try {
            return (ApiMediationServiceConfig)this.objectMapper.readValue(configData, ApiMediationServiceConfig.class);
        }
        catch (IOException e) {
            throw new ServiceDefinitionException("Configuration data can't be parsed as ApiMediationServiceConfig.", (Throwable)e);
        }
    }

    public Map<String, String> setApiMlServiceContext(ServletContext servletContext) {
        Map threadContextMap = ObjectUtil.getThreadContextMap(this.threadConfigurationContext);
        Enumeration paramNames = servletContext.getInitParameterNames();
        while (paramNames.hasMoreElements()) {
            String param = (String)paramNames.nextElement();
            String value = servletContext.getInitParameter(param);
            if (!param.startsWith("apiml.")) continue;
            threadContextMap.put(param, value);
        }
        return threadContextMap;
    }

    public ApiMediationServiceConfig loadConfiguration(ServletContext context) throws ServiceDefinitionException {
        String externalConfigurationFileName;
        this.initializeContextMap();
        this.setApiMlSystemProperties();
        this.setApiMlServiceContext(context);
        Map threadContextMap = ObjectUtil.getThreadContextMap(this.threadConfigurationContext);
        String basicConfigurationFileName = (String)threadContextMap.get(APIML_DEFAULT_CONFIG);
        if (basicConfigurationFileName == null) {
            basicConfigurationFileName = (String)threadContextMap.get(APIML_DEFAULT_CONFIG);
        }
        if ((externalConfigurationFileName = (String)threadContextMap.get(APIML_ADDITIONAL_CONFIG)) == null) {
            externalConfigurationFileName = (String)threadContextMap.get(APIML_ADDITIONAL_CONFIG);
        }
        return this.loadConfiguration(basicConfigurationFileName, externalConfigurationFileName, true);
    }

    private Map<String, String> setApiMlSystemProperties() {
        Map threadContextMap = ObjectUtil.getThreadContextMap(this.threadConfigurationContext);
        Enumeration<?> propertyNames = System.getProperties().propertyNames();
        while (propertyNames.hasMoreElements()) {
            String param = (String)propertyNames.nextElement();
            String value = System.getProperties().getProperty(param);
            if (!param.startsWith("apiml.")) continue;
            threadContextMap.put(param, value);
        }
        return threadContextMap;
    }

    private void initializeContextMap() {
        this.threadConfigurationContext.remove();
    }
}

