/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.eurekaservice.client.util;

import com.google.common.primitives.Chars;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.apiml.eurekaservice.client.config.ApiMediationServiceConfig;
import org.zowe.apiml.eurekaservice.client.config.Route;
import org.zowe.apiml.eurekaservice.client.config.Ssl;
import org.zowe.apiml.exception.MetadataValidationException;

public class EurekaInstanceConfigValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EurekaInstanceConfigValidator.class);
    private static final String UNSET_VALUE_STRING = "{apiml.";
    private static final char[] UNSET_VALUE_CHAR_ARRAY = "{apiml.".toCharArray();
    private final List<String> missingSslParameters = new ArrayList<String>();
    private final List<String> missingRoutesParameters = new ArrayList<String>();
    private final List<String> poorlyFormedRelativeUrlParameters = new ArrayList<String>();

    public void validate(ApiMediationServiceConfig config) {
        this.validateRoutes(config.getRoutes());
        if (config.getDiscoveryServiceUrls().stream().anyMatch(url -> url.toLowerCase().startsWith("https"))) {
            this.validateSsl(config.getSsl());
        }
        this.validateUrls(config);
        if (config.getCatalog() == null) {
            log.warn("The API Catalog UI tile configuration is not provided. Try to add apiml.service.catalog.tile section.");
        }
        if (config.getApiInfo() == null || config.getApiInfo().isEmpty()) {
            log.warn("The API info configuration is not provided. Try to add apiml.service.apiInfo section.");
        }
    }

    private void validateRoutes(List<Route> routes) {
        if (routes == null || routes.isEmpty()) {
            throw new MetadataValidationException("Routes configuration was not provided. Try to add apiml.service.routes section.");
        }
        routes.forEach(route -> {
            if (this.isInvalid(route.getGatewayUrl())) {
                this.addParameterToProblemsList("gatewayUrl", this.missingRoutesParameters);
            }
            if (this.isInvalid(route.getServiceUrl())) {
                this.addParameterToProblemsList("serviceUrl", this.missingRoutesParameters);
            }
            if (!this.missingRoutesParameters.isEmpty()) {
                throw new MetadataValidationException(String.format("Routes parameters  ** %s ** are missing or were not replaced by the system properties.", String.join((CharSequence)", ", this.missingRoutesParameters)));
            }
        });
    }

    private void validateSsl(Ssl ssl) {
        if (ssl == null) {
            throw new MetadataValidationException("SSL configuration was not provided. Try add apiml.service.ssl section.");
        }
        if (this.isInvalid(ssl.getProtocol())) {
            this.addParameterToProblemsList("protocol", this.missingSslParameters);
        }
        if (this.isInvalid(ssl.getTrustStore())) {
            this.addParameterToProblemsList("trustStore", this.missingSslParameters);
        }
        if (this.isInvalid(ssl.getKeyStore())) {
            this.addParameterToProblemsList("keyStore", this.missingSslParameters);
        }
        if (this.isInvalid(ssl.getKeyAlias())) {
            this.addParameterToProblemsList("keyAlias", this.missingSslParameters);
        }
        if (this.isInvalid(ssl.getKeyStoreType())) {
            this.addParameterToProblemsList("keyStoreType", this.missingSslParameters);
        }
        if (this.isInvalid(ssl.getTrustStoreType())) {
            this.addParameterToProblemsList("trustStoreType", this.missingSslParameters);
        }
        if (this.isInvalid(ssl.getTrustStorePassword()) && (this.isInvalid(ssl.getTrustStoreType()) || !this.isInvalid(ssl.getTrustStoreType()) && !ssl.getTrustStoreType().equals("JCERACFKS"))) {
            this.addParameterToProblemsList("trustStorePassword", this.missingSslParameters);
        }
        if (this.isInvalid(ssl.getKeyStorePassword()) && (this.isInvalid(ssl.getKeyStoreType()) || !this.isInvalid(ssl.getKeyStoreType()) && !ssl.getKeyStoreType().equals("JCERACFKS"))) {
            this.addParameterToProblemsList("keyStorePassword", this.missingSslParameters);
        }
        if (this.isInvalid(ssl.getKeyPassword())) {
            this.addParameterToProblemsList("keyPassword", this.missingSslParameters);
        }
        if (ssl.getEnabled() == null) {
            this.addParameterToProblemsList("enabled", this.missingSslParameters);
        }
        if (!this.missingSslParameters.isEmpty()) {
            throw new MetadataValidationException(String.format("SSL parameters ** %s ** are missing or were not replaced by the system properties.", String.join((CharSequence)", ", this.missingSslParameters)));
        }
    }

    private void validateUrls(ApiMediationServiceConfig config) {
        this.validateHomePageRelativeUrl(config);
        if (this.isPoorlyFormedRelativeUrl(config.getHealthCheckRelativeUrl())) {
            this.addParameterToProblemsList("healthCheckRelativeUrl", this.poorlyFormedRelativeUrlParameters);
        }
        if (this.isPoorlyFormedRelativeUrl(config.getStatusPageRelativeUrl())) {
            this.addParameterToProblemsList("statusPageRelativeUrl", this.poorlyFormedRelativeUrlParameters);
        }
        if (this.isPoorlyFormedRelativeUrl(config.getContextPath())) {
            this.addParameterToProblemsList("contextPath", this.poorlyFormedRelativeUrlParameters);
        }
        if (!this.poorlyFormedRelativeUrlParameters.isEmpty()) {
            log.warn(String.format("Relative URL parameters ** %s ** don't begin with '/' which often causes malformed URLs.", String.join((CharSequence)", ", this.poorlyFormedRelativeUrlParameters)));
        }
        if (config.getBaseUrl() != null && config.getBaseUrl().endsWith("/")) {
            log.warn("The baseUrl parameter ends with a trailing '/'. This often causes malformed URLs when relative URLs are used.");
        }
        if (config.getContextPath() != null && config.getContextPath().endsWith("/")) {
            log.warn("The contextPath parameter ends with a trailing '/'. This often causes malformed URLs when relative URLs are used.");
        }
    }

    private void validateHomePageRelativeUrl(ApiMediationServiceConfig config) {
        String homePageUrl = config.getHomePageRelativeUrl();
        if (this.isInvalid(homePageUrl) && config.getRoutes().stream().anyMatch(route -> route.getGatewayUrl().toLowerCase().startsWith("ui"))) {
            log.warn("The home page URL is not provided. Try to add apiml.service.homePageRelativeUrl property or check its value.");
        } else if (this.isPoorlyFormedRelativeUrl(homePageUrl)) {
            this.addParameterToProblemsList("homePageRelativeUrl", this.poorlyFormedRelativeUrlParameters);
        }
    }

    private boolean isPoorlyFormedRelativeUrl(String url) {
        return url != null && !url.startsWith("/");
    }

    private boolean isInvalid(String value) {
        return value == null || value.isEmpty() || value.contains(UNSET_VALUE_STRING);
    }

    private boolean isInvalid(char[] value) {
        return value == null || value.length == 0 || Chars.indexOf((char[])value, (char[])UNSET_VALUE_CHAR_ARRAY) >= 0;
    }

    private void addParameterToProblemsList(String parameter, List<String> problemParameters) {
        problemParameters.add(parameter);
    }
}

