/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.eurekaservice.client.util;

import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.apiml.eurekaservice.client.config.ApiMediationServiceConfig;
import org.zowe.apiml.eurekaservice.client.config.Route;
import org.zowe.apiml.eurekaservice.client.config.Ssl;
import org.zowe.apiml.exception.MetadataValidationException;

public class EurekaInstanceConfigValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EurekaInstanceConfigValidator.class);

    public void validate(ApiMediationServiceConfig config) {
        this.validateRoutes(config.getRoutes());
        this.validateSsl(config.getSsl());
        if (config.getCatalog() == null) {
            log.warn("The API Catalog UI tile configuration is not provided. Try to add apiml.service.catalog.tile section.");
        }
        if (this.isInvalid(config.getHomePageRelativeUrl())) {
            log.warn("The home page URL is not provided. Try to add apiml.service.homePageRelativeUrl property or check its value.");
        }
        if (config.getApiInfo() == null || config.getApiInfo().isEmpty()) {
            log.warn("The API info configuration is not provided. Try to add apiml.service.apiInfo section.");
        }
    }

    private void validateRoutes(List<Route> routes) {
        if (routes == null || routes.isEmpty()) {
            throw new MetadataValidationException("Routes configuration was not provided. Try to add apiml.service.routes section.");
        }
        routes.forEach(route -> {
            if (this.isInvalid(route.getGatewayUrl()) || this.isInvalid(route.getServiceUrl())) {
                throw new MetadataValidationException("Routes parameters are missing or were not replaced by the system properties.");
            }
        });
    }

    private void validateSsl(Ssl ssl) {
        if (ssl == null) {
            throw new MetadataValidationException("SSL configuration was not provided. Try add apiml.service.ssl section.");
        }
        if (this.isInvalid(ssl.getProtocol()) || this.isInvalid(ssl.getTrustStorePassword()) || this.isInvalid(ssl.getTrustStore()) || this.isInvalid(ssl.getKeyStorePassword()) || this.isInvalid(ssl.getKeyStore()) || this.isInvalid(ssl.getKeyAlias()) || this.isInvalid(ssl.getKeyStoreType()) || this.isInvalid(ssl.getTrustStoreType()) || this.isInvalid(ssl.getKeyPassword()) || ssl.getEnabled() == null) {
            throw new MetadataValidationException("SSL parameters are missing or were not replaced by the system properties.");
        }
    }

    private boolean isInvalid(String value) {
        return value == null || value.isEmpty() || value.contains("{apiml.");
    }
}

