/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery.config;

import java.util.Collections;
import javax.servlet.Filter;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.zowe.apiml.discovery.config.AbstractWebSecurityConfigurer;
import org.zowe.apiml.security.client.EnableApimlAuth;
import org.zowe.apiml.security.client.login.GatewayLoginProvider;
import org.zowe.apiml.security.client.token.GatewayTokenProvider;
import org.zowe.apiml.security.common.config.AuthConfigurationProperties;
import org.zowe.apiml.security.common.config.HandlerInitializer;
import org.zowe.apiml.security.common.content.BasicContentFilter;
import org.zowe.apiml.security.common.content.CookieContentFilter;

@Configuration
@EnableWebSecurity
@EnableApimlAuth
@Profile(value={"https"})
public class HttpsWebSecurityConfig {
    private final HandlerInitializer handlerInitializer;
    private final AuthConfigurationProperties securityConfigurationProperties;
    private final GatewayLoginProvider gatewayLoginProvider;
    private final GatewayTokenProvider gatewayTokenProvider;
    private static final String DISCOVERY_REALM = "API Mediation Discovery Service realm";

    private BasicContentFilter basicFilter(AuthenticationManager authenticationManager) {
        return new BasicContentFilter(authenticationManager, (AuthenticationFailureHandler)this.handlerInitializer.getAuthenticationFailureHandler(), this.handlerInitializer.getResourceAccessExceptionHandler());
    }

    private CookieContentFilter cookieFilter(AuthenticationManager authenticationManager) {
        return new CookieContentFilter(authenticationManager, (AuthenticationFailureHandler)this.handlerInitializer.getAuthenticationFailureHandler(), this.handlerInitializer.getResourceAccessExceptionHandler(), this.securityConfigurationProperties);
    }

    private UserDetailsService x509UserDetailsService() {
        return username -> new User("eurekaClient", "", Collections.emptyList());
    }

    @Generated
    public HttpsWebSecurityConfig(HandlerInitializer handlerInitializer, AuthConfigurationProperties securityConfigurationProperties, GatewayLoginProvider gatewayLoginProvider, GatewayTokenProvider gatewayTokenProvider) {
        this.handlerInitializer = handlerInitializer;
        this.securityConfigurationProperties = securityConfigurationProperties;
        this.gatewayLoginProvider = gatewayLoginProvider;
        this.gatewayTokenProvider = gatewayTokenProvider;
    }

    @Configuration
    @Order(value=3)
    public class FilterChainBasicAuthOrTokenOrCert
    extends AbstractWebSecurityConfigurer {
        @Value(value="${apiml.security.ssl.verifySslCertificatesOfServices:true}")
        private boolean verifySslCertificatesOfServices;
        @Value(value="${apiml.security.ssl.nonStrictVerifySslCertificatesOfServices:false}")
        private boolean nonStrictVerifySslCertificatesOfServices;

        protected void configure(AuthenticationManagerBuilder auth) {
            auth.authenticationProvider((AuthenticationProvider)HttpsWebSecurityConfig.this.gatewayLoginProvider);
            auth.authenticationProvider((AuthenticationProvider)HttpsWebSecurityConfig.this.gatewayTokenProvider);
        }

        protected void configure(HttpSecurity http) throws Exception {
            this.baseConfigure(http.antMatcher("/discovery/**")).addFilterBefore((Filter)HttpsWebSecurityConfig.this.basicFilter(this.authenticationManager()), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)HttpsWebSecurityConfig.this.cookieFilter(this.authenticationManager()), UsernamePasswordAuthenticationFilter.class).httpBasic().realmName(HttpsWebSecurityConfig.DISCOVERY_REALM);
            if (this.verifySslCertificatesOfServices || this.nonStrictVerifySslCertificatesOfServices) {
                ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).authenticated().and()).x509().userDetailsService(HttpsWebSecurityConfig.this.x509UserDetailsService());
            }
        }
    }

    @Configuration
    @Order(value=2)
    public class FilterChainClientCertificate
    extends AbstractWebSecurityConfigurer {
        @Value(value="${apiml.security.ssl.verifySslCertificatesOfServices:true}")
        private boolean verifySslCertificatesOfServices;
        @Value(value="${apiml.security.ssl.nonStrictVerifySslCertificatesOfServices:false}")
        private boolean nonStrictVerifySslCertificatesOfServices;

        public void configure(WebSecurity web) {
            String[] noSecurityAntMatchers = new String[]{"/eureka/css/**", "/eureka/js/**", "/eureka/fonts/**", "/eureka/images/**"};
            web.ignoring().antMatchers(noSecurityAntMatchers);
        }

        protected void configure(HttpSecurity http) throws Exception {
            this.baseConfigure(http.antMatcher("/eureka/**"));
            if (this.verifySslCertificatesOfServices || this.nonStrictVerifySslCertificatesOfServices) {
                ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).authenticated().and()).x509().userDetailsService(HttpsWebSecurityConfig.this.x509UserDetailsService());
            } else {
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).permitAll();
            }
        }
    }

    @Configuration
    @Order(value=1)
    public class FilterChainBasicAuthOrToken
    extends AbstractWebSecurityConfigurer {
        protected void configure(AuthenticationManagerBuilder auth) {
            auth.authenticationProvider((AuthenticationProvider)HttpsWebSecurityConfig.this.gatewayLoginProvider);
            auth.authenticationProvider((AuthenticationProvider)HttpsWebSecurityConfig.this.gatewayTokenProvider);
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)this.baseConfigure(((HttpSecurity.RequestMatcherConfigurer)http.requestMatchers().antMatchers(new String[]{"/application/**", "/*"})).and()).addFilterBefore((Filter)HttpsWebSecurityConfig.this.basicFilter(this.authenticationManager()), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)HttpsWebSecurityConfig.this.cookieFilter(this.authenticationManager()), UsernamePasswordAuthenticationFilter.class).authorizeRequests().antMatchers(new String[]{"/application/health", "/application/info", "/favicon.ico"})).permitAll().antMatchers(new String[]{"/**"})).authenticated().and()).httpBasic().realmName(HttpsWebSecurityConfig.DISCOVERY_REALM);
        }
    }
}

