/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.eureka.EurekaServerContext;
import com.netflix.eureka.EurekaServerContextHolder;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.util.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.message.log.ApimlLogger;
import org.zowe.apiml.product.constants.CoreService;
import org.zowe.apiml.util.EurekaUtils;

@Component
public class GatewayNotifier
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GatewayNotifier.class);
    public static final String GATEWAY_SERVICE_ID = CoreService.GATEWAY.getServiceId().toUpperCase();
    private static final String DISTRIBUTE_PATH = "/gateway/auth/distribute/";
    private static final String CACHE_PATH = "/gateway/cache/services";
    private final ApimlLogger logger;
    private final RestTemplate restTemplate;
    private boolean stopped;
    private BlockingQueue<Notification> queue = new LinkedBlockingQueue<Notification>();
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();

    public GatewayNotifier(@Qualifier(value="restTemplateWithKeystore") RestTemplate restTemplate, MessageService messageService) {
        this.restTemplate = restTemplate;
        this.logger = ApimlLogger.of(GatewayNotifier.class, (MessageService)messageService);
    }

    @PostConstruct
    public void afterPropertiesSet() {
        this.threadPoolTaskExecutor.initialize();
        this.threadPoolTaskExecutor.execute((Runnable)this);
    }

    @PreDestroy
    public void preDestroy() {
        this.stopped = true;
    }

    private EurekaServerContext getServerContext() {
        return EurekaServerContextHolder.getInstance().getServerContext();
    }

    private PeerAwareInstanceRegistry getRegistry() {
        return this.getServerContext().getRegistry();
    }

    private List<InstanceInfo> getGatewayInstances() {
        PeerAwareInstanceRegistry registry = this.getRegistry();
        Application application = registry.getApplication(GATEWAY_SERVICE_ID);
        if (application == null) {
            this.logger.log("org.zowe.apiml.discovery.errorNotifyingGateway", new Object[0]);
            return Collections.emptyList();
        }
        return application.getInstances();
    }

    protected void addToQueue(Notification notification) {
        if (!this.queue.contains(notification)) {
            this.queue.add(notification);
        }
    }

    public void serviceUpdated(String serviceId, String instanceId) {
        Notification notification = new Notification(serviceId, instanceId, Type.SERVICE_UPDATED);
        this.addToQueue(notification);
    }

    public void distributeInvalidatedCredentials(String instanceId) {
        Notification notification = new Notification(null, instanceId, Type.DISTRIBUTE_INVALIDATED_CREDENTIALS);
        this.addToQueue(notification);
    }

    private void notify(String instanceId, Consumer<InstanceInfo> call) {
        List<InstanceInfo> gatewayInstances = this.getGatewayInstances();
        for (InstanceInfo instanceInfo : gatewayInstances) {
            if (StringUtils.equalsIgnoreCase((String)instanceId, (String)instanceInfo.getInstanceId())) continue;
            call.accept(instanceInfo);
        }
    }

    protected void serviceUpdatedProcess(String serviceId, String instanceId) {
        this.notify(instanceId, instanceInfo -> {
            StringBuilder url = new StringBuilder();
            url.append(EurekaUtils.getUrl((InstanceInfo)instanceInfo)).append(CACHE_PATH);
            if (serviceId != null) {
                url.append('/').append(serviceId);
            }
            try {
                this.restTemplate.delete(url.toString(), new Object[0]);
            }
            catch (Exception e) {
                log.debug("Cannot notify the Gateway {} about {}", new Object[]{url.toString(), instanceId, e});
                this.logger.log("org.zowe.apiml.discovery.registration.gateway.notify", new Object[]{url.toString(), instanceId});
            }
        });
    }

    protected void distributeInvalidatedCredentialsProcess(String instanceId) {
        this.notify(instanceId, instanceInfo -> {
            StringBuilder url = new StringBuilder();
            url.append(EurekaUtils.getUrl((InstanceInfo)instanceInfo)).append(DISTRIBUTE_PATH).append(instanceId);
            try {
                this.restTemplate.getForEntity(url.toString(), Void.class, new Object[0]);
            }
            catch (Exception e) {
                log.debug("Cannot notify the Gateway {} about {}", new Object[]{url.toString(), instanceId, e});
                this.logger.log("org.zowe.apiml.discovery.registration.gateway.notify", new Object[]{url.toString(), instanceId});
            }
        });
    }

    @Override
    public void run() {
        while (!this.stopped) {
            try {
                Notification notification = this.queue.poll(10L, TimeUnit.SECONDS);
                if (notification == null) continue;
                notification.process();
            }
            catch (InterruptedException e) {
                log.debug("Thread for Gateway notification was interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                log.debug("Unexpected exception on gateway notifier", (Throwable)e);
            }
        }
    }

    private static enum Type {
        SERVICE_UPDATED((BiConsumer<GatewayNotifier, Notification>)((BiConsumer)(gatewayNotifier, notification) -> gatewayNotifier.serviceUpdatedProcess(((Notification)notification).serviceId, ((Notification)notification).instanceId))),
        DISTRIBUTE_INVALIDATED_CREDENTIALS((BiConsumer<GatewayNotifier, Notification>)((BiConsumer)(gatewayNotifier, notification) -> gatewayNotifier.distributeInvalidatedCredentialsProcess(((Notification)notification).instanceId)));

        private final BiConsumer<GatewayNotifier, Notification> call;

        @Generated
        private Type(BiConsumer<GatewayNotifier, Notification> call) {
            this.call = call;
        }
    }

    protected class Notification {
        private final String serviceId;
        private final String instanceId;
        private final Type type;

        protected void process() {
            this.type.call.accept((Object)GatewayNotifier.this, (Object)this);
        }

        @Generated
        public Notification(String serviceId, String instanceId, Type type) {
            this.serviceId = serviceId;
            this.instanceId = instanceId;
            this.type = type;
        }

        @Generated
        public String getServiceId() {
            return this.serviceId;
        }

        @Generated
        public String getInstanceId() {
            return this.instanceId;
        }

        @Generated
        public Type getType() {
            return this.type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Notification)) {
                return false;
            }
            Notification other = (Notification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$serviceId = this.getServiceId();
            String other$serviceId = other.getServiceId();
            if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
                return false;
            }
            String this$instanceId = this.getInstanceId();
            String other$instanceId = other.getInstanceId();
            if (this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId)) {
                return false;
            }
            Type this$type = this.getType();
            Type other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Notification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $serviceId = this.getServiceId();
            result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
            String $instanceId = this.getInstanceId();
            result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }
    }
}

