/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.client.configuration;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityScheme;
import org.springdoc.core.GroupedOpenApi;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SwaggerConfiguration {
    @Value(value="${apiml.service.title}")
    private String apiTitle;
    @Value(value="${apiml.service.apiInfo[0].version}")
    private String apiVersionRest1;
    @Value(value="${apiml.service.apiInfo[1].version}")
    private String graphqlVersion;
    @Value(value="${apiml.service.apiInfo[2].version}")
    private String apiVersionRest2;
    @Value(value="${apiml.service.description}")
    private String apiDescription;

    @Bean
    public OpenAPI openAPI() {
        return new OpenAPI().info(new Info().title(this.apiTitle).description(this.apiDescription)).components(new Components().addSecuritySchemes("ESM token", new SecurityScheme().type(SecurityScheme.Type.APIKEY).in(SecurityScheme.In.HEADER).name("esmToken")));
    }

    @Bean
    public GroupedOpenApi apiV1() {
        return GroupedOpenApi.builder().group("apiv1").pathsToMatch(new String[]{"/api/v1/**"}).addOpenApiCustomiser(openApi -> openApi.setInfo(openApi.getInfo().version(this.apiVersionRest1))).build();
    }

    @Bean
    public GroupedOpenApi apiV2() {
        return GroupedOpenApi.builder().group("apiv2").pathsToMatch(new String[]{"/api/v2/**"}).addOpenApiCustomiser(openApi -> openApi.setInfo(openApi.getInfo().version(this.apiVersionRest2))).build();
    }

    @Bean
    public GroupedOpenApi graphV1() {
        return GroupedOpenApi.builder().group("graphv1").pathsToMatch(new String[]{"/graphql/v1/**"}).addOpenApiCustomiser(openApi -> openApi.setInfo(openApi.getInfo().version(this.graphqlVersion))).build();
    }
}

