/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.client.api;

import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import io.swagger.v3.oas.annotations.Operation;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class StatusCodeController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatusCodeController.class);

    @GetMapping(value={"/api/v1/status-code"})
    @Operation(summary="Parametrized status code", tags={"Other Operations"})
    public ResponseEntity<String> returnStatusCodeForGET(@RequestParam(value="code", defaultValue="200") int statusCode) {
        log.info("Calling GET from gateway, status code: {}", (Object)statusCode);
        return ResponseEntity.status((int)statusCode).body((Object)("status code: " + statusCode));
    }

    @PostMapping(value={"/api/v1/status-code"})
    @Operation(summary="Parametrized status code", tags={"Other Operations"})
    @HystrixCommand
    public ResponseEntity<String> returnStatusCodeForPOST(@RequestParam(value="code", defaultValue="200") int statusCode) {
        log.info("Calling POST from gateway, status code: {}", (Object)statusCode);
        return ResponseEntity.status((int)statusCode).body((Object)("status code: " + statusCode));
    }
}

