/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.client.service;

import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.zowe.apiml.client.model.DiscoverableClientConfig;
import org.zowe.apiml.config.ApiInfo;
import org.zowe.apiml.eurekaservice.client.ApiMediationClient;
import org.zowe.apiml.eurekaservice.client.config.ApiMediationServiceConfig;
import org.zowe.apiml.eurekaservice.client.config.Authentication;
import org.zowe.apiml.eurekaservice.client.config.Route;
import org.zowe.apiml.eurekaservice.client.config.Ssl;
import org.zowe.apiml.eurekaservice.client.impl.ApiMediationClientImpl;
import org.zowe.apiml.exception.ServiceDefinitionException;

@Service
public class ApiMediationClientService {
    private static final String PORT = "10013";
    private static final String SERVICE_ID = "registrationTest";
    private static final String GATEWAY_URL = "api/v1";
    private final DiscoverableClientConfig dcConfig;
    private final ApiMediationClient apiMediationClient = new ApiMediationClientImpl();

    public ApiMediationClientService(@Autowired DiscoverableClientConfig dcConfig) {
        this.dcConfig = dcConfig;
    }

    public boolean register() throws ServiceDefinitionException {
        ApiInfo apiInfo = new ApiInfo(SERVICE_ID, GATEWAY_URL, "1.0.0", null, null);
        Authentication authentication = new Authentication("bypass", null, null);
        Ssl ssl = new Ssl(Boolean.valueOf(this.dcConfig.isSslEnabled()), Boolean.valueOf(this.dcConfig.isVerifyCerts()), Boolean.valueOf(this.dcConfig.isNonStrictVerifyCerts()), this.dcConfig.getSslProtocol(), this.dcConfig.getKeyAlias(), this.dcConfig.getKeyPassword().toCharArray(), this.dcConfig.getKeyStore(), this.dcConfig.getKeyStorePassword().toCharArray(), this.dcConfig.getKeyStoreType(), this.dcConfig.getTrustStore(), this.dcConfig.getTrustStorePassword().toCharArray(), this.dcConfig.getTrustStoreType());
        Route apiRoute = new Route(GATEWAY_URL, "/registrationTest/api/v1");
        ApiMediationServiceConfig apiConfig = ApiMediationServiceConfig.builder().apiInfo(Collections.singletonList(apiInfo)).authentication(authentication).routes(Collections.singletonList(apiRoute)).description("Example for API Mediation Client registration").title("API Mediation Client Registration").serviceId(SERVICE_ID).baseUrl(this.dcConfig.getScheme() + "://" + this.dcConfig.getHostname() + ":" + PORT).healthCheckRelativeUrl("").homePageRelativeUrl("").statusPageRelativeUrl("").discoveryServiceUrls(this.dcConfig.getDiscoveryServiceUrls()).ssl(ssl).preferIpAddress(false).serviceIpAddress("0.0.0.0").build();
        this.apiMediationClient.register(apiConfig);
        return true;
    }

    public boolean unregister() {
        this.apiMediationClient.unregister();
        return true;
    }

    public boolean isRegistered() {
        return this.apiMediationClient.isRegistered();
    }
}

