/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.client.api;

import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.zowe.apiml.client.exception.PetIdMismatchException;
import org.zowe.apiml.client.exception.PetNotFoundException;
import org.zowe.apiml.client.model.Pet;
import org.zowe.apiml.client.model.state.Existing;
import org.zowe.apiml.client.model.state.New;
import org.zowe.apiml.client.service.PetService;

@RestController
@RequestMapping(value={"/api/v1"})
@Tag(description="/api/v1/pets", name="The pet API")
public class PetController {
    private final PetService petService;

    @Autowired
    public PetController(PetService petService) {
        this.petService = petService;
    }

    @GetMapping(value={"/pets"}, produces={"application/json"})
    @Operation(summary="List all existing pets", description="Returns information about all existing pets")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of pets")})
    @HystrixCommand
    public List<Pet> getAllPets() {
        List<Pet> pets = this.petService.getAll();
        if (pets == null) {
            return new ArrayList<Pet>();
        }
        return pets;
    }

    @PostMapping(value={"/pets"}, produces={"application/json"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Add a new pet", description="Creates a new pet", security={@SecurityRequirement(name="ESM token")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="New created pet"), @ApiResponse(responseCode="401", description="Authentication is required"), @ApiResponse(responseCode="400", description="Request object is not valid")})
    @HystrixCommand
    public Pet addPet(@Parameter(description="Pet object that needs to be added", required=true) @Validated(value={New.class}) @RequestBody Pet pet) {
        return this.petService.save(pet);
    }

    @GetMapping(value={"/pets/{id}"}, produces={"application/json"})
    @Operation(summary="Find pet by id", description="Returns a single pet", security={@SecurityRequirement(name="ESM token")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Authentication is required"), @ApiResponse(responseCode="404", description="The pet with id is not found.")})
    @HystrixCommand
    public Pet getPetById(@Parameter(description="Pet id to return", required=true, example="1") @PathVariable(value="id") Long id) {
        Pet pet = this.petService.getById(id);
        if (pet == null) {
            throw new PetNotFoundException("Pet with provided id is not found", id);
        }
        return pet;
    }

    @PutMapping(value={"/pets/{id}"}, produces={"application/json"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update an existing pet", description="Change information for an existing pet", security={@SecurityRequirement(name="ESM token")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Pet updated"), @ApiResponse(responseCode="401", description="Authentication is required"), @ApiResponse(responseCode="404", description="Pet not found")})
    @HystrixCommand
    public Pet updatePetById(@Parameter(description="Pet id to update", required=true, example="1") @PathVariable(value="id") Long id, @Parameter(description="Pet object that needs to be updated", required=true) @Validated(value={Existing.class}) @RequestBody Pet pet) {
        if (!id.equals(pet.getId())) {
            throw new PetIdMismatchException("Id in URL is different from request body id", id, pet.getId());
        }
        Pet updatedPet = this.petService.update(pet);
        if (updatedPet == null) {
            throw new PetNotFoundException("Pet with provided id is not found", pet.getId());
        }
        return updatedPet;
    }

    @DeleteMapping(value={"/pets/{id}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Delete a pet", description="Removes an existing pet", security={@SecurityRequirement(name="ESM token")})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Pet updated"), @ApiResponse(responseCode="401", description="Authentication is required"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Pet not found")})
    @HystrixCommand
    public void deletePetById(@Parameter(description="Pet id to delete", required=true, example="1") @PathVariable(value="id") Long id) {
        this.petService.deleteById(id);
    }
}

