/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.client.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Import;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.zowe.apiml.client.api.LoginRequest;
import org.zowe.apiml.zaasclient.config.DefaultZaasClientConfiguration;
import org.zowe.apiml.zaasclient.exception.ZaasClientException;
import org.zowe.apiml.zaasclient.exception.ZaasConfigurationException;
import org.zowe.apiml.zaasclient.service.ZaasClient;

@RestController
@RequestMapping(value={"/api/v1/zaasClient"})
@Api(value="/api/v1/zaasClient", consumes="application/json", tags={"Zaas client test call"})
@Import(value={DefaultZaasClientConfiguration.class})
public class ZaasClientTestController {
    private ZaasClient zaasClient;

    public ZaasClientTestController(ZaasClient zaasClient) {
        this.zaasClient = zaasClient;
    }

    @PostMapping(value={"/login"})
    @ApiOperation(value="Forward login to gateway service via zaas client")
    public ResponseEntity<String> forwardLogin(@RequestBody LoginRequest loginRequest) {
        try {
            String jwt = this.zaasClient.login(loginRequest.getUsername(), loginRequest.getPassword());
            return ResponseEntity.ok().body((Object)jwt);
        }
        catch (ZaasClientException e) {
            return ResponseEntity.status((int)e.getErrorCode().getReturnCode()).body((Object)e.getErrorCode().getMessage());
        }
    }

    @PostMapping(value={"/logout"})
    @ApiOperation(value="Forward logout to gateway service via zaas client")
    public ResponseEntity<String> forwardLogout(@CookieValue(value="apimlAuthenticationToken", required=false) String cookieToken, @RequestHeader(value="Authorization", required=false) String authorizationHeader) throws ZaasConfigurationException {
        if (StringUtils.isEmpty((CharSequence)cookieToken) && StringUtils.isEmpty((CharSequence)authorizationHeader)) {
            return ResponseEntity.status((int)500).body((Object)"Missing cookie or authorization header in the request");
        }
        try {
            String token = StringUtils.isEmpty((CharSequence)cookieToken) ? authorizationHeader : cookieToken;
            this.zaasClient.logout(token);
        }
        catch (ZaasClientException e) {
            return ResponseEntity.status((int)e.getErrorCode().getReturnCode()).body((Object)e.getErrorCode().getMessage());
        }
        return ResponseEntity.noContent().build();
    }
}

