/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.client.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.zowe.apiml.client.exception.PetIdMismatchException;
import org.zowe.apiml.client.exception.PetNotFoundException;
import org.zowe.apiml.client.model.Pet;
import org.zowe.apiml.client.model.state.Existing;
import org.zowe.apiml.client.model.state.New;
import org.zowe.apiml.client.service.PetService;
import org.zowe.apiml.message.api.ApiMessageView;

@RestController
@RequestMapping(value={"/api/v1"})
@Api(value="/api/v1/pets", consumes="application/json", tags={"The pet API"})
public class PetController {
    private final PetService petService;

    @Autowired
    public PetController(PetService petService) {
        this.petService = petService;
    }

    @GetMapping(value={"/pets"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="List all existing pets", notes="Returns information about all existing pets")
    @ApiResponses(value={@ApiResponse(code=200, message="List of pets", response=Pet.class, responseContainer="List")})
    public List<Pet> getAllPets() {
        List<Pet> pets = this.petService.getAll();
        if (pets == null) {
            return new ArrayList<Pet>();
        }
        return pets;
    }

    @PostMapping(value={"/pets"}, produces={"application/json;charset=UTF-8"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Add a new pet", notes="Creates a new pet", authorizations={@Authorization(value="ESM token")})
    @ApiResponses(value={@ApiResponse(code=200, message="New created pet", response=Pet.class), @ApiResponse(code=401, message="Authentication is required", response=ApiMessageView.class), @ApiResponse(code=400, message="Request object is not valid", response=ApiMessageView.class)})
    public Pet addPet(@ApiParam(value="Pet object that needs to be added", required=true) @Validated(value={New.class}) @RequestBody Pet pet) {
        return this.petService.save(pet);
    }

    @GetMapping(value={"/pets/{id}"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="Find pet by id", notes="Returns a single pet", authorizations={@Authorization(value="ESM token")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Pet.class), @ApiResponse(code=401, message="Authentication is required", response=ApiMessageView.class), @ApiResponse(code=404, message="The pet with id is not found.", response=ApiMessageView.class)})
    public Pet getPetById(@ApiParam(value="Pet id to return", required=true, example="1") @PathVariable(value="id") Long id) {
        Pet pet = this.petService.getById(id);
        if (pet == null) {
            throw new PetNotFoundException("Pet with provided id is not found", id);
        }
        return pet;
    }

    @PutMapping(value={"/pets/{id}"}, produces={"application/json;charset=UTF-8"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Update an existing pet", notes="Change information for an existing pet", authorizations={@Authorization(value="ESM token")})
    @ApiResponses(value={@ApiResponse(code=200, message="Pet updated", response=Pet.class), @ApiResponse(code=401, message="Authentication is required", response=ApiMessageView.class), @ApiResponse(code=404, message="Pet not found", response=ApiMessageView.class)})
    public Pet updatePetById(@ApiParam(value="Pet id to update", required=true, example="1") @PathVariable(value="id") Long id, @ApiParam(value="Pet object that needs to be updated", required=true) @Validated(value={Existing.class}) @RequestBody Pet pet) {
        if (!id.equals(pet.getId())) {
            throw new PetIdMismatchException("Id in URL is different from request body id", id, pet.getId());
        }
        Pet updatedPet = this.petService.update(pet);
        if (updatedPet == null) {
            throw new PetNotFoundException("Pet with provided id is not found", pet.getId());
        }
        return updatedPet;
    }

    @DeleteMapping(value={"/pets/{id}"}, produces={"application/json;charset=UTF-8"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiOperation(value="Delete a pet", notes="Removes an existing pet", authorizations={@Authorization(value="ESM token")})
    @ApiResponses(value={@ApiResponse(code=204, message="Pet updated", response=Pet.class), @ApiResponse(code=401, message="Authentication is required", response=ApiMessageView.class), @ApiResponse(code=403, message="Forbidden", response=ApiMessageView.class), @ApiResponse(code=404, message="Pet not found", response=ApiMessageView.class)})
    public void deletePetById(@ApiParam(value="Pet id to delete", required=true, example="1") @PathVariable(value="id") Long id) {
        this.petService.deleteById(id);
    }
}

