/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.client;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.zowe.apiml.enable.EnableApiDiscovery;
import org.zowe.apiml.product.logging.annotations.EnableApimlLogger;
import org.zowe.apiml.product.monitoring.LatencyUtilsConfigInitializer;
import org.zowe.apiml.product.service.ServiceStartupEventHandler;
import org.zowe.apiml.product.version.BuildInfo;

@SpringBootApplication
@EnableApiDiscovery
@EnableWebSocket
@EnableApimlLogger
public class DiscoverableClientSampleApplication
implements ApplicationListener<ApplicationReadyEvent> {
    public static void main(String[] args) {
        SpringApplication app = new SpringApplication(new Class[]{DiscoverableClientSampleApplication.class});
        app.addInitializers(new ApplicationContextInitializer[]{new LatencyUtilsConfigInitializer()});
        app.setLogStartupInfo(false);
        new BuildInfo().logBuildInfo();
        app.run(args);
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        new ServiceStartupEventHandler().onServiceStartup("Discoverable Client Service", 5);
    }
}

