/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.service.vsam;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.annotation.Retryable;
import org.zowe.apiml.caching.model.KeyValue;
import org.zowe.apiml.caching.service.EvictionStrategy;
import org.zowe.apiml.caching.service.Messages;
import org.zowe.apiml.caching.service.Storage;
import org.zowe.apiml.caching.service.StorageException;
import org.zowe.apiml.caching.service.vsam.EvictionStrategyProducer;
import org.zowe.apiml.caching.service.vsam.RetryableVsamException;
import org.zowe.apiml.caching.service.vsam.VsamFile;
import org.zowe.apiml.caching.service.vsam.VsamFileProducer;
import org.zowe.apiml.caching.service.vsam.VsamInitializer;
import org.zowe.apiml.caching.service.vsam.VsamRecord;
import org.zowe.apiml.caching.service.vsam.config.VsamConfig;
import org.zowe.apiml.message.log.ApimlLogger;

public class VsamStorage
implements Storage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VsamStorage.class);
    private VsamConfig vsamConfig;
    private EvictionStrategyProducer evictionStrategyProducer;
    private VsamFileProducer producer = new VsamFileProducer();
    private ApimlLogger apimlLog;

    public VsamStorage(VsamConfig vsamConfig, VsamInitializer vsamInitializer, ApimlLogger apimlLog, EvictionStrategyProducer evictionStrategyProducer) {
        log.info("Using VSAM storage for the cached data");
        this.apimlLog = apimlLog;
        String vsamFileName = vsamConfig.getFileName();
        if (vsamFileName == null || vsamFileName.isEmpty()) {
            apimlLog.log("org.zowe.apiml.cache.errorInitializingStorage", new Object[]{"vsam", "wrong Configuration", "VSAM Filename must be valid"});
            throw new IllegalArgumentException("Vsam filename must be valid");
        }
        this.vsamConfig = vsamConfig;
        this.evictionStrategyProducer = evictionStrategyProducer;
        log.info("Using Vsam configuration: {}", (Object)vsamConfig);
        vsamInitializer.storageWarmup(vsamConfig, apimlLog);
    }

    public VsamStorage(VsamConfig vsamConfig, VsamInitializer vsamInitializer, VsamFileProducer producer, ApimlLogger apimlLogger, EvictionStrategyProducer evictionStrategyProducer) {
        this(vsamConfig, vsamInitializer, apimlLogger, evictionStrategyProducer);
        this.producer = producer;
    }

    private EvictionStrategy provideStrategy(VsamFile file) {
        return this.evictionStrategyProducer.evictionStrategy(file);
    }

    @Override
    @Retryable(value={RetryableVsamException.class, IllegalStateException.class, UnsupportedOperationException.class})
    public KeyValue create(String serviceId, KeyValue toCreate) {
        log.info("Writing record: {}|{}|{}", new Object[]{serviceId, toCreate.getKey(), toCreate.getValue()});
        KeyValue result = null;
        try (VsamFile file = this.producer.newVsamFile(this.vsamConfig, VsamConfig.VsamOptions.WRITE, this.apimlLog);){
            Optional<VsamRecord> returned;
            toCreate.setServiceId(serviceId);
            VsamRecord vsamRec = new VsamRecord(this.vsamConfig, serviceId, toCreate);
            int currentSize = file.countAllRecords();
            log.info("Current Size {}.", (Object)currentSize);
            if (this.aboveThreshold(currentSize)) {
                EvictionStrategy strategy = this.provideStrategy(file);
                log.info("Evicting record using the {} strategy", (Object)this.vsamConfig.getGeneralConfig().getEvictionStrategy());
                strategy.evict(toCreate.getKey());
            }
            if ((returned = file.create(vsamRec)).isPresent()) {
                result = returned.get().getKeyValue();
            }
        }
        if (result == null) {
            throw new StorageException(Messages.DUPLICATE_KEY.getKey(), Messages.DUPLICATE_KEY.getStatus(), toCreate.getKey(), serviceId);
        }
        return result;
    }

    private boolean aboveThreshold(int currentSize) {
        return currentSize >= this.vsamConfig.getGeneralConfig().getMaxDataSize();
    }

    @Override
    @Retryable(value={RetryableVsamException.class})
    public KeyValue read(String serviceId, String key) {
        log.info("Reading Record: {}|{}|{}", new Object[]{serviceId, key, "-"});
        KeyValue result = null;
        try (VsamFile file = this.producer.newVsamFile(this.vsamConfig, VsamConfig.VsamOptions.READ, this.apimlLog);){
            VsamRecord vsamRec = new VsamRecord(this.vsamConfig, serviceId, new KeyValue(key, "", serviceId));
            Optional<VsamRecord> returned = file.read(vsamRec);
            if (returned.isPresent()) {
                result = returned.get().getKeyValue();
            }
        }
        if (result == null) {
            throw new StorageException(Messages.KEY_NOT_IN_CACHE.getKey(), Messages.KEY_NOT_IN_CACHE.getStatus(), key, serviceId);
        }
        return result;
    }

    @Override
    @Retryable(value={RetryableVsamException.class, IllegalStateException.class, UnsupportedOperationException.class})
    public KeyValue update(String serviceId, KeyValue toUpdate) {
        log.info("Updating Record: {}|{}|{}", new Object[]{serviceId, toUpdate.getKey(), toUpdate.getValue()});
        KeyValue result = null;
        try (VsamFile file = this.producer.newVsamFile(this.vsamConfig, VsamConfig.VsamOptions.WRITE, this.apimlLog);){
            toUpdate.setServiceId(serviceId);
            VsamRecord vsamRec = new VsamRecord(this.vsamConfig, serviceId, toUpdate);
            Optional<VsamRecord> returned = file.update(vsamRec);
            if (returned.isPresent()) {
                result = returned.get().getKeyValue();
            }
        }
        if (result == null) {
            throw new StorageException(Messages.KEY_NOT_IN_CACHE.getKey(), Messages.KEY_NOT_IN_CACHE.getStatus(), toUpdate.getKey(), serviceId);
        }
        return result;
    }

    @Override
    @Retryable(value={RetryableVsamException.class, IllegalStateException.class, UnsupportedOperationException.class})
    public KeyValue delete(String serviceId, String toDelete) {
        log.info("Deleting Record: {}|{}|{}", new Object[]{serviceId, toDelete, "-"});
        KeyValue result = null;
        try (VsamFile file = this.producer.newVsamFile(this.vsamConfig, VsamConfig.VsamOptions.WRITE, this.apimlLog);){
            VsamRecord vsamRec = new VsamRecord(this.vsamConfig, serviceId, new KeyValue(toDelete, "", serviceId));
            Optional<VsamRecord> returned = file.delete(vsamRec);
            if (returned.isPresent()) {
                result = returned.get().getKeyValue();
            }
        }
        if (result == null) {
            throw new StorageException(Messages.KEY_NOT_IN_CACHE.getKey(), Messages.KEY_NOT_IN_CACHE.getStatus(), toDelete, serviceId);
        }
        return result;
    }

    @Override
    public Map<String, KeyValue> readForService(String serviceId) {
        List<VsamRecord> returned;
        log.info("Reading All Records: {}|{}|{}", new Object[]{serviceId, "-", "-"});
        HashMap<String, KeyValue> result = new HashMap<String, KeyValue>();
        try (VsamFile file = this.producer.newVsamFile(this.vsamConfig, VsamConfig.VsamOptions.READ, this.apimlLog);){
            returned = file.readForService(serviceId);
        }
        returned.forEach(vsamRecord -> result.put(vsamRecord.getKeyValue().getKey(), vsamRecord.getKeyValue()));
        return result;
    }

    @Override
    public void deleteForService(String serviceId) {
        log.info("Deleting All Records: {}|{}|{}", new Object[]{serviceId, "-", "-"});
        try (VsamFile file = this.producer.newVsamFile(this.vsamConfig, VsamConfig.VsamOptions.WRITE, this.apimlLog);){
            file.deleteForService(serviceId);
        }
    }
}

