/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.service.vsam;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.apiml.caching.config.VsamConfig;
import org.zowe.apiml.caching.model.KeyValue;
import org.zowe.apiml.caching.service.Storage;
import org.zowe.apiml.caching.service.vsam.VsamFile;
import org.zowe.apiml.caching.service.vsam.VsamKey;
import org.zowe.apiml.caching.service.vsam.VsamRecord;
import org.zowe.apiml.caching.service.vsam.VsamRecordException;
import org.zowe.apiml.util.ObjectUtil;
import org.zowe.apiml.zfile.RcException;
import org.zowe.apiml.zfile.ZFileException;

public class VsamStorage
implements Storage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VsamStorage.class);
    public static final String VSAM_RECORD_ERROR_MESSAGE = "VsamRecordException occured: {}";
    public static final String RECORD_FOUND_MESSAGE = "Record found: {}";
    public static final String UNSUPPORTED_ENCODING_MESSAGE = "Unsupported encoding: {}";
    String options = "ab+,type=record";
    VsamConfig vsamConfig;
    VsamKey key;

    public VsamStorage(VsamConfig config) {
        log.info("Using VSAM storage for the cached data");
        ObjectUtil.requireNotNull((Object)config.getFileName(), (String)"Vsam filename cannot be null");
        ObjectUtil.requireNotEmpty((String)config.getFileName(), (String)"Vsam filename cannot be empty");
        this.vsamConfig = config;
        this.key = new VsamKey(config);
        log.info("Using Vsam configuration: {}", (Object)this.vsamConfig);
        try (VsamFile file = new VsamFile(config);){
            file.warmUpVsamFile();
        }
        catch (RcException | ZFileException e) {
            log.error("Problem initializing VSAM storage, opening of {} in mode {} has failed", (Object)this.vsamConfig, (Object)this.options);
            log.error(e.toString());
        }
        catch (VsamRecordException e) {
            log.error(VSAM_RECORD_ERROR_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public KeyValue create(String serviceId, KeyValue toCreate) {
        log.info("Writing record: {}|{}|{}", new Object[]{serviceId, toCreate.getKey(), toCreate.getValue()});
        KeyValue result = null;
        try (VsamFile zfile = new VsamFile(this.vsamConfig);){
            VsamRecord record = new VsamRecord(this.vsamConfig, serviceId, toCreate);
            boolean found = zfile.locate(record.getKeyBytes(), 3);
            if (!found) {
                log.info("Writing Record: {}", (Object)record);
                zfile.write(record.getBytes());
                result = toCreate;
            } else {
                log.error("The record already exists and will not be created. Use update instead.");
            }
        }
        catch (ZFileException e) {
            log.error(e.toString());
        }
        catch (VsamRecordException e) {
            log.error(VSAM_RECORD_ERROR_MESSAGE, (Throwable)e);
        }
        return result;
    }

    @Override
    public KeyValue read(String serviceId, String key) {
        log.info("Reading Record: {}|{}|{}", new Object[]{serviceId, key, "-"});
        KeyValue result = null;
        try (VsamFile zfile = new VsamFile(this.vsamConfig);){
            boolean found = zfile.locate(this.key.getKeyBytes(serviceId, key), 3);
            log.info(RECORD_FOUND_MESSAGE, (Object)found);
            if (found) {
                byte[] recBuf = new byte[this.vsamConfig.getRecordLength()];
                zfile.read(recBuf);
                log.info("RecBuf: {}", (Object)recBuf);
                log.info("ConvertedStringValue: {}", (Object)new String(recBuf, this.vsamConfig.getEncoding()));
                VsamRecord record = new VsamRecord(this.vsamConfig, serviceId, recBuf);
                log.info("VsamRecord read: {}", (Object)record);
                result = record.getKeyValue();
            }
        }
        catch (ZFileException e) {
            log.error(e.toString());
        }
        catch (UnsupportedEncodingException e) {
            log.error(UNSUPPORTED_ENCODING_MESSAGE, (Object)"IBM-1047");
        }
        catch (VsamRecordException e) {
            log.error(VSAM_RECORD_ERROR_MESSAGE, (Throwable)e);
        }
        return result;
    }

    @Override
    public KeyValue update(String serviceId, KeyValue toUpdate) {
        log.info("Updating Record: {}|{}|{}", new Object[]{serviceId, toUpdate.getKey(), toUpdate.getValue()});
        KeyValue result = null;
        try (VsamFile zfile = new VsamFile(this.vsamConfig);){
            boolean found = zfile.locate(this.key.getKeyBytes(serviceId, toUpdate.getKey()), 3);
            log.info(RECORD_FOUND_MESSAGE, (Object)found);
            if (found) {
                byte[] recBuf = new byte[this.vsamConfig.getRecordLength()];
                zfile.read(recBuf);
                log.info("Read found record: {}", (Object)new String(recBuf, "IBM-1047"));
                VsamRecord record = new VsamRecord(this.vsamConfig, serviceId, toUpdate);
                log.info("Construct updated record: {}", (Object)record);
                int nUpdated = zfile.update(record.getBytes());
                log.info("ZFile.update return value: {}", (Object)nUpdated);
                result = record.getKeyValue();
            } else {
                log.error("No record updated because no record found with key");
            }
        }
        catch (ZFileException e) {
            log.error(e.toString());
        }
        catch (UnsupportedEncodingException e) {
            log.error(UNSUPPORTED_ENCODING_MESSAGE, (Object)"IBM-1047");
        }
        catch (VsamRecordException e) {
            log.error(VSAM_RECORD_ERROR_MESSAGE, (Throwable)e);
        }
        return result;
    }

    @Override
    public KeyValue delete(String serviceId, String toDelete) {
        log.info("Deleting Record: {}|{}|{}", new Object[]{serviceId, toDelete, "-"});
        KeyValue result = null;
        try (VsamFile zfile = new VsamFile(this.vsamConfig);){
            boolean found = zfile.locate(this.key.getKeyBytes(serviceId, toDelete), 3);
            log.info(RECORD_FOUND_MESSAGE, (Object)found);
            if (found) {
                byte[] recBuf = new byte[this.vsamConfig.getRecordLength()];
                zfile.read(recBuf);
                VsamRecord record = new VsamRecord(this.vsamConfig, serviceId, recBuf);
                zfile.delrec();
                log.info("Deleted vsam record: {}", (Object)record);
                result = record.getKeyValue();
            } else {
                log.error("No record deleted because no record found with key");
            }
        }
        catch (ZFileException e) {
            log.error(e.toString());
        }
        catch (UnsupportedEncodingException e) {
            log.error(UNSUPPORTED_ENCODING_MESSAGE, (Object)"IBM-1047");
        }
        catch (VsamRecordException e) {
            log.error(VSAM_RECORD_ERROR_MESSAGE, (Throwable)e);
        }
        return result;
    }

    @Override
    public Map<String, KeyValue> readForService(String serviceId) {
        log.info("Reading All Records: {}|{}|{}", new Object[]{serviceId, "-", "-"});
        HashMap<String, KeyValue> result = new HashMap<String, KeyValue>();
        try (VsamFile zfile = new VsamFile(this.vsamConfig);){
            byte[] recBuf = new byte[this.vsamConfig.getRecordLength()];
            log.info("Attempt to find key in KEY_GE mode: {}", (Object)this.key.getKeySidOnly(serviceId));
            boolean found = zfile.locate(this.key.getKeyBytesSidOnly(serviceId), 5);
            log.info(RECORD_FOUND_MESSAGE, (Object)found);
            int overflowProtection = 10000;
            while (found) {
                int nread = zfile.read(recBuf);
                log.info("RecBuf: {}", (Object)recBuf);
                log.info("nread: {}", (Object)nread);
                log.info("ConvertedStringValue: {}", (Object)new String(recBuf, "IBM-1047"));
                if (nread < 0) {
                    log.info("nread is < 0, stopping the retrieval");
                    found = false;
                    continue;
                }
                VsamRecord record = new VsamRecord(this.vsamConfig, serviceId, recBuf);
                log.info("Read record: {}", (Object)record);
                result.put(record.getKeyValue().getKey(), record.getKeyValue());
                if (--overflowProtection > 0) continue;
                log.error("Maximum number of records retrieved, stopping the retrieval");
                break;
            }
        }
        catch (ZFileException e) {
            log.error(e.toString());
        }
        catch (UnsupportedEncodingException e) {
            log.error(UNSUPPORTED_ENCODING_MESSAGE, (Object)"IBM-1047");
        }
        catch (VsamRecordException e) {
            log.error(VSAM_RECORD_ERROR_MESSAGE, (Throwable)e);
        }
        return result;
    }
}

