/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.service.vsam;

import java.io.UnsupportedEncodingException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.zowe.apiml.caching.config.VsamConfig;
import org.zowe.apiml.caching.model.KeyValue;

public class VsamKey {
    private final VsamConfig config;
    int keyLength;

    public VsamKey(VsamConfig config) {
        if (config.getKeyLength() < 23) {
            throw new IllegalArgumentException("VsamKey cannot have length smaller than 23 characters");
        }
        this.config = config;
        this.keyLength = config.getKeyLength();
    }

    public String toString() {
        return "vsamkey";
    }

    public String getKey(String serviceId, String key) {
        return StringUtils.rightPad((String)(serviceId.hashCode() + ":" + key.hashCode()), (int)this.keyLength);
    }

    public String getKey(String serviceId, KeyValue keyValue) {
        return this.getKey(serviceId, keyValue.getKey());
    }

    public byte[] getKeyBytes(String serviceId, String key) throws UnsupportedEncodingException {
        return this.getKey(serviceId, key).getBytes(this.config.getEncoding());
    }

    public byte[] getKeyBytes(String serviceId, KeyValue keyValue) throws UnsupportedEncodingException {
        return this.getKey(serviceId, keyValue.getKey()).getBytes(this.config.getEncoding());
    }

    public String getKeySidOnly(String serviceId) {
        return StringUtils.rightPad((String)String.valueOf(serviceId.hashCode()), (int)this.keyLength);
    }

    public byte[] getKeyBytesSidOnly(String serviceId) throws UnsupportedEncodingException {
        return this.getKeySidOnly(serviceId).getBytes(this.config.getEncoding());
    }

    @Generated
    public int getKeyLength() {
        return this.keyLength;
    }
}

