/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.service.vsam;

import java.io.Closeable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.apiml.caching.config.VsamConfig;
import org.zowe.apiml.caching.model.KeyValue;
import org.zowe.apiml.caching.service.vsam.VsamRecord;
import org.zowe.apiml.caching.service.vsam.VsamRecordException;
import org.zowe.apiml.util.ClassOrDefaultProxyUtils;
import org.zowe.apiml.zfile.EnqueueException;
import org.zowe.apiml.zfile.RcException;
import org.zowe.apiml.zfile.ZFile;
import org.zowe.apiml.zfile.ZFileDummyImpl;
import org.zowe.apiml.zfile.ZFileException;

public class VsamFile
implements Closeable,
ZFile {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VsamFile.class);
    private ZFile zfile;
    private VsamConfig vsamConfig;
    private String options = "ab+,type=record";

    public VsamFile(VsamConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Cannot create VsamFile with null configuration");
        }
        this.vsamConfig = config;
        try {
            this.zfile = this.openZfile();
        }
        catch (ZFileException e) {
            throw new IllegalStateException("Failed to open VsamFile");
        }
    }

    @Override
    public void close() {
        if (this.zfile != null) {
            try {
                this.zfile.close();
            }
            catch (ZFileException e) {
                log.error("Closing ZFile failed");
            }
        }
    }

    public void warmUpVsamFile() throws ZFileException, VsamRecordException {
        log.info("Warming up the vsam file by writing and deleting a record");
        log.info("VSAM file being used: {}", (Object)this.zfile.getActualFilename());
        VsamRecord record = new VsamRecord(this.vsamConfig, "delete", new KeyValue("me", "novalue"));
        log.info("Writing Record: {}", (Object)record);
        this.zfile.write(record.getBytes());
        boolean found = this.zfile.locate(record.getKeyBytes(), 3);
        log.info("Test record for deletion found: {}", (Object)found);
        if (found) {
            byte[] recBuf = new byte[this.vsamConfig.getRecordLength()];
            this.zfile.read(recBuf);
            this.zfile.delrec();
            log.info("Test record deleted.");
        }
    }

    private ZFile openZfile() throws ZFileException {
        return (ZFile)ClassOrDefaultProxyUtils.createProxyByConstructor(ZFile.class, (String)"com.ibm.jzos.ZFile", ZFileDummyImpl::new, (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{this.vsamConfig.getFileName(), this.options}, (ClassOrDefaultProxyUtils.ExceptionMapping[])new ClassOrDefaultProxyUtils.ExceptionMapping[]{new ClassOrDefaultProxyUtils.ByMethodName("com.ibm.jzos.ZFileException", ZFileException.class, new String[]{"getFileName", "getMessage", "getErrnoMsg", "getErrno", "getErrno2", "getLastOp", "getAmrcBytes", "getAbendCode", "getAbendRc", "getFeedbackRc", "getFeedbackFtncd", "getFeedbackFdbk"}), new ClassOrDefaultProxyUtils.ByMethodName("com.ibm.jzos.RcException", RcException.class, new String[]{"getMessage", "getRc"}), new ClassOrDefaultProxyUtils.ByMethodName("com.ibm.jzos.EnqueueException", EnqueueException.class, new String[]{"getMessage", "getRc"})});
    }

    public void delrec() throws ZFileException {
        this.zfile.delrec();
    }

    public boolean locate(byte[] key, int options) throws ZFileException {
        return this.zfile.locate(key, options);
    }

    public boolean locate(byte[] key, int offset, int length, int options) throws ZFileException {
        return this.zfile.locate(key, offset, length, options);
    }

    public boolean locate(long recordNumberOrRBA, int options) throws ZFileException {
        return this.zfile.locate(recordNumberOrRBA, options);
    }

    public int read(byte[] buf) throws ZFileException {
        return this.zfile.read(buf);
    }

    public int read(byte[] buf, int offset, int len) throws ZFileException {
        return this.zfile.read(buf, offset, len);
    }

    public int update(byte[] buf) throws ZFileException {
        return this.zfile.update(buf);
    }

    public int update(byte[] buf, int offset, int length) throws ZFileException {
        return this.zfile.update(buf, offset, length);
    }

    public void write(byte[] buf) throws ZFileException {
        this.zfile.write(buf);
    }

    public void write(byte[] buf, int offset, int len) throws ZFileException {
        this.zfile.write(buf, offset, len);
    }

    public String getActualFilename() {
        return this.zfile.getActualFilename();
    }
}

