/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.service.inmemory;

import java.util.HashMap;
import java.util.Map;
import org.zowe.apiml.caching.model.KeyValue;
import org.zowe.apiml.caching.service.Storage;

public class InMemoryStorage
implements Storage {
    private Map<String, Map<String, KeyValue>> storage = new HashMap<String, Map<String, KeyValue>>();

    public InMemoryStorage() {
    }

    protected InMemoryStorage(Map<String, Map<String, KeyValue>> storage) {
        this.storage = storage;
    }

    @Override
    public KeyValue create(String serviceId, KeyValue toCreate) {
        this.storage.computeIfAbsent(serviceId, k -> new HashMap());
        Map<String, KeyValue> serviceStorage = this.storage.get(serviceId);
        serviceStorage.put(toCreate.getKey(), toCreate);
        return toCreate;
    }

    @Override
    public KeyValue read(String serviceId, String key) {
        Map<String, KeyValue> serviceSpecificStorage = this.storage.get(serviceId);
        if (serviceSpecificStorage == null) {
            return null;
        }
        return serviceSpecificStorage.get(key);
    }

    @Override
    public KeyValue update(String serviceId, KeyValue toUpdate) {
        String keyToUpdate = toUpdate.getKey();
        if (this.isKeyNotInCache(serviceId, keyToUpdate)) {
            return null;
        }
        Map<String, KeyValue> serviceStorage = this.storage.get(serviceId);
        serviceStorage.put(keyToUpdate, toUpdate);
        return toUpdate;
    }

    @Override
    public KeyValue delete(String serviceId, String toDelete) {
        if (this.isKeyNotInCache(serviceId, toDelete)) {
            return null;
        }
        Map<String, KeyValue> serviceSpecificStorage = this.storage.get(serviceId);
        return serviceSpecificStorage.remove(toDelete);
    }

    @Override
    public Map<String, KeyValue> readForService(String serviceId) {
        return this.storage.get(serviceId);
    }

    private boolean isKeyNotInCache(String serviceId, String keyToTest) {
        Map<String, KeyValue> serviceSpecificStorage = this.storage.get(serviceId);
        return serviceSpecificStorage == null || serviceSpecificStorage.get(keyToTest) == null;
    }
}

