/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.api;

import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.zowe.apiml.caching.exceptions.CachingPayloadException;
import org.zowe.apiml.caching.model.KeyValue;
import org.zowe.apiml.caching.service.Storage;
import org.zowe.apiml.message.core.Message;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.zaasclient.config.DefaultZaasClientConfiguration;
import org.zowe.apiml.zaasclient.exception.ZaasClientErrorCodes;
import org.zowe.apiml.zaasclient.exception.ZaasClientException;
import org.zowe.apiml.zaasclient.service.ZaasClient;
import org.zowe.apiml.zaasclient.service.ZaasToken;

@RestController
@RequestMapping(value={"/api/v1"})
@Import(value={DefaultZaasClientConfiguration.class})
public class CachingController {
    private static final String TOKEN_COOKIE_PREFIX = "apimlAuthenticationToken";
    private static final String KEY_NOT_IN_CACHE_MESSAGE = "org.zowe.apiml.cache.keyNotInCache";
    private final Storage storage;
    private final ZaasClient zaasClient;
    private final MessageService messageService;

    @GetMapping(value={"/cache/{key}"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="Retrieves a specific value in the cache", notes="Value returned is for the provided {key}")
    @ResponseBody
    public ResponseEntity<Object> getValue(@PathVariable String key, HttpServletRequest request) {
        String serviceId;
        try {
            ZaasToken token = this.queryTokenFromRequest(request);
            serviceId = token.getUserId();
        }
        catch (ZaasClientException e) {
            return this.handleZaasClientException(e, request);
        }
        if (key == null) {
            return this.noKeyProvidedResponse(serviceId);
        }
        KeyValue readPair = this.storage.read(serviceId, key);
        if (readPair == null) {
            Message message = this.messageService.createMessage(KEY_NOT_IN_CACHE_MESSAGE, new Object[]{key, serviceId});
            return new ResponseEntity((Object)message.mapToView(), HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)readPair, HttpStatus.OK);
    }

    @GetMapping(value={"/cache"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="Retrieves all values in the cache", notes="Values returned for the calling service")
    @ResponseBody
    public ResponseEntity<Object> getAllValues(HttpServletRequest request) {
        String serviceId;
        try {
            ZaasToken token = this.queryTokenFromRequest(request);
            serviceId = token.getUserId();
        }
        catch (ZaasClientException e) {
            return this.handleZaasClientException(e, request);
        }
        return new ResponseEntity(this.storage.readForService(serviceId), HttpStatus.OK);
    }

    @PostMapping(value={"/cache"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="Create a new key in the cache", notes="A new key-value pair will be added to the cache")
    @ResponseBody
    public ResponseEntity<Object> createKey(@RequestBody KeyValue keyValue, HttpServletRequest request) {
        String serviceId;
        try {
            ZaasToken token = this.queryTokenFromRequest(request);
            serviceId = token.getUserId();
            this.checkForInvalidPayload(keyValue);
        }
        catch (ZaasClientException e) {
            return this.handleZaasClientException(e, request);
        }
        catch (CachingPayloadException e) {
            return this.invalidPayloadResponse(e, keyValue);
        }
        KeyValue createdPair = this.storage.create(serviceId, keyValue);
        if (createdPair == null) {
            Message message = this.messageService.createMessage("org.zowe.apiml.cache.keyCollision", new Object[]{keyValue.getKey()});
            return new ResponseEntity((Object)message.mapToView(), HttpStatus.CONFLICT);
        }
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @PutMapping(value={"/cache"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="Update key in the cache", notes="Value at the key in the provided key-value pair will be updated to the provided value")
    @ResponseBody
    public ResponseEntity<Object> update(@RequestBody KeyValue keyValue, HttpServletRequest request) {
        String serviceId;
        try {
            ZaasToken token = this.queryTokenFromRequest(request);
            serviceId = token.getUserId();
            this.checkForInvalidPayload(keyValue);
        }
        catch (ZaasClientException e) {
            return this.handleZaasClientException(e, request);
        }
        catch (CachingPayloadException e) {
            return this.invalidPayloadResponse(e, keyValue);
        }
        KeyValue updatedPair = this.storage.update(serviceId, keyValue);
        if (updatedPair == null) {
            Message message = this.messageService.createMessage(KEY_NOT_IN_CACHE_MESSAGE, new Object[]{keyValue.getKey(), serviceId});
            return new ResponseEntity((Object)message.mapToView(), HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @DeleteMapping(value={"/cache/{key}"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="Delete key from the cache", notes="Will delete key-value pair for the provided {key}")
    @ResponseBody
    public ResponseEntity<Object> delete(@PathVariable String key, HttpServletRequest request) {
        String serviceId;
        try {
            ZaasToken token = this.queryTokenFromRequest(request);
            serviceId = token.getUserId();
        }
        catch (ZaasClientException e) {
            return this.handleZaasClientException(e, request);
        }
        if (key == null) {
            return this.noKeyProvidedResponse(serviceId);
        }
        KeyValue deletedPair = this.storage.delete(serviceId, key);
        if (deletedPair == null) {
            Message message = this.messageService.createMessage(KEY_NOT_IN_CACHE_MESSAGE, new Object[]{key, serviceId});
            return new ResponseEntity((Object)message.mapToView(), HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private void checkForInvalidPayload(KeyValue keyValue) throws CachingPayloadException {
        if (keyValue == null) {
            throw new CachingPayloadException("No KeyValue provided in the payload");
        }
        if (keyValue.getValue() == null) {
            throw new CachingPayloadException("No value provided in the payload");
        }
        String key = keyValue.getKey();
        if (key == null) {
            throw new CachingPayloadException("No key provided in the payload");
        }
        if (!StringUtils.isAlphanumeric((CharSequence)key)) {
            throw new CachingPayloadException("Key is not alphanumeric");
        }
    }

    private ResponseEntity<Object> invalidPayloadResponse(CachingPayloadException e, KeyValue keyValue) {
        Message message = this.messageService.createMessage("org.zowe.apiml.cache.invalidPayload", new Object[]{keyValue, e.getMessage()});
        return new ResponseEntity((Object)message.mapToView(), HttpStatus.BAD_REQUEST);
    }

    private ResponseEntity<Object> noKeyProvidedResponse(String serviceId) {
        Message message = this.messageService.createMessage("org.zowe.apiml.cache.keyNotProvided", new Object[]{serviceId});
        return new ResponseEntity((Object)message.mapToView(), HttpStatus.BAD_REQUEST);
    }

    private ZaasToken queryTokenFromRequest(HttpServletRequest request) throws ZaasClientException {
        String jwtToken = this.getJwtTokenFromCookie(request);
        ZaasToken zaasToken = this.zaasClient.query(jwtToken);
        if (zaasToken == null) {
            throw new ZaasClientException(ZaasClientErrorCodes.INVALID_JWT_TOKEN, "Queried token is null");
        }
        if (zaasToken.isExpired()) {
            throw new ZaasClientException(ZaasClientErrorCodes.EXPIRED_JWT_EXCEPTION, "Queried token is expired");
        }
        return zaasToken;
    }

    private String getJwtTokenFromCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        return Arrays.stream(cookies).filter(cookie -> cookie.getName().equals(TOKEN_COOKIE_PREFIX)).filter(cookie -> !cookie.getValue().isEmpty()).findFirst().map(Cookie::getValue).orElse(null);
    }

    private ResponseEntity<Object> handleZaasClientException(ZaasClientException e, HttpServletRequest request) {
        Message message;
        HttpStatus statusCode;
        String requestUrl = request.getRequestURL().toString();
        switch (e.getErrorCode()) {
            case TOKEN_NOT_PROVIDED: {
                statusCode = HttpStatus.BAD_REQUEST;
                message = this.messageService.createMessage("org.zowe.apiml.security.query.tokenNotProvided", new Object[]{requestUrl});
                break;
            }
            case INVALID_JWT_TOKEN: {
                statusCode = HttpStatus.UNAUTHORIZED;
                message = this.messageService.createMessage("org.zowe.apiml.security.query.invalidToken", new Object[]{requestUrl});
                break;
            }
            case EXPIRED_JWT_EXCEPTION: {
                statusCode = HttpStatus.UNAUTHORIZED;
                message = this.messageService.createMessage("org.zowe.apiml.security.expiredToken", new Object[]{requestUrl});
                break;
            }
            case SERVICE_UNAVAILABLE: {
                statusCode = HttpStatus.NOT_FOUND;
                message = this.messageService.createMessage("org.zowe.apiml.cache.gatewayUnavailable", new Object[]{requestUrl, e.getMessage()});
                break;
            }
            default: {
                statusCode = HttpStatus.INTERNAL_SERVER_ERROR;
                message = this.messageService.createMessage("org.zowe.apiml.common.internalRequestError", new Object[]{requestUrl, e.getMessage(), e.getCause()});
            }
        }
        return new ResponseEntity((Object)message.mapToView(), statusCode);
    }

    @Generated
    public CachingController(Storage storage, ZaasClient zaasClient, MessageService messageService) {
        this.storage = storage;
        this.zaasClient = zaasClient;
        this.messageService = messageService;
    }
}

