/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.read.ListAppender;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.LoggerFactory;

public class LogMessageTracker {
    private final ListAppender<ILoggingEvent> logAppender = new ListAppender();

    public LogMessageTracker(Class<?> loggedClass) {
        this(loggedClass.getName());
    }

    public LogMessageTracker(String loggerName) {
        this.logAppender.setContext((Context)((LoggerContext)LoggerFactory.getILoggerFactory()));
        Logger log = (Logger)LoggerFactory.getLogger((String)loggerName);
        log.setLevel(Level.ALL);
        log.addAppender(this.logAppender);
    }

    public void startTracking() {
        this.logAppender.start();
    }

    public void stopTracking() {
        this.logAppender.list.clear();
        this.logAppender.stop();
    }

    public boolean contains(Pattern regex) {
        return this.logAppender.list.stream().anyMatch(event -> regex.matcher(event.getFormattedMessage()).find());
    }

    public boolean contains(String content) {
        return this.logAppender.list.stream().anyMatch(event -> event.getFormattedMessage().contains(content));
    }

    public boolean contains(Pattern regex, Level level) {
        return this.logAppender.list.stream().anyMatch(event -> regex.matcher(event.getFormattedMessage()).find() && event.getLevel().equals(level));
    }

    public boolean contains(String content, Level level) {
        return this.logAppender.list.stream().anyMatch(event -> event.getFormattedMessage().contains(content) && event.getLevel().equals(level));
    }

    public List<ILoggingEvent> search(Pattern regex) {
        return this.logAppender.list.stream().filter(event -> regex.matcher(event.getFormattedMessage()).find()).toList();
    }

    public List<ILoggingEvent> search(String content) {
        return this.logAppender.list.stream().filter(event -> event.getFormattedMessage().contains(content)).toList();
    }

    public List<ILoggingEvent> search(Pattern regex, Level level) {
        return this.logAppender.list.stream().filter(event -> regex.matcher(event.getFormattedMessage()).find() && event.getLevel().equals(level)).toList();
    }

    public List<ILoggingEvent> search(String content, Level level) {
        return this.logAppender.list.stream().filter(event -> event.getFormattedMessage().contains(content) && event.getLevel().equals(level)).toList();
    }

    public long countEvents() {
        return this.logAppender.list.size();
    }

    public List<ILoggingEvent> getAllLoggedEvents() {
        return Collections.unmodifiableList(this.logAppender.list);
    }

    public List<ILoggingEvent> getAllLoggedEventsWithLevel(Level level) {
        return this.logAppender.list.stream().filter(event -> event.getLevel().equals(level)).toList();
    }
}

