/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.logging;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

public class MaskingLogPatternLayout
extends PatternLayout {
    private static final String MASK_VALUE = "***";
    private static final Pattern maskPatterns = new MaskPatternBuilder().addJsonValue("password", new String[0]).addJsonValue("newPassword", new String[0]).build();

    public String doLayout(ILoggingEvent event) {
        return this.maskMessage(super.doLayout(event));
    }

    protected String maskMessage(String message) {
        StringBuilder sb = new StringBuilder(message);
        Matcher matcher = maskPatterns.matcher(sb);
        while (matcher.find()) {
            IntStream.rangeClosed(1, matcher.groupCount()).forEach(group -> {
                if (matcher.group(group) != null) {
                    sb.replace(matcher.start(group), matcher.end(group), MASK_VALUE);
                }
            });
        }
        return sb.toString();
    }

    public static class MaskPatternBuilder {
        private final List<String> maskPatterns = new ArrayList<String>();

        public MaskPatternBuilder add(String prefix, String capture) {
            return this.add(prefix, capture, "");
        }

        public MaskPatternBuilder add(String prefix, String capture, String postfix) {
            this.maskPatterns.add(prefix + "(" + capture + ")" + postfix);
            return this;
        }

        public MaskPatternBuilder addJsonValue(String jsonKey, String ... keys) {
            this.add("\\\"" + jsonKey + "\\\"\\s*:\\s*", "\\\".*?\\\"");
            for (String k : keys) {
                this.add("\\\"" + k + "\\\"\\s*:\\s*", "\\\".*?\\\"");
            }
            return this;
        }

        public Pattern build() {
            return Pattern.compile(String.join((CharSequence)"|", this.maskPatterns), 8);
        }
    }
}

