/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.web;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Set;
import org.apache.catalina.connector.Connector;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.stereotype.Component;

@Component
public class TomcatDefaultCertificate
implements TomcatConnectorCustomizer {
    private void fixDefaultCertificate(SSLHostConfig sslHostConfig) {
        Set originalSet = sslHostConfig.getCertificates();
        if (originalSet.isEmpty()) {
            return;
        }
        try {
            Field defaultCertificateField = sslHostConfig.getClass().getDeclaredField("defaultCertificate");
            defaultCertificateField.setAccessible(true);
            if (defaultCertificateField.get(sslHostConfig) == null) {
                defaultCertificateField.set(sslHostConfig, originalSet.iterator().next());
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Cannot update Tomcat SSL context", e);
        }
    }

    public void customize(Connector connector) {
        Arrays.stream(connector.findSslHostConfigs()).forEach(this::fixDefaultCertificate);
    }
}

