/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.gzip;

import jakarta.servlet.http.HttpServletResponse;
import org.zowe.apiml.gzip.GZipResponseException;

public final class GZipResponseUtils {
    private static final int EMPTY_GZIPPED_CONTENT_SIZE = 20;

    private GZipResponseUtils() {
    }

    public static boolean shouldGzippedBodyBeZero(byte[] compressedBytes) {
        return compressedBytes.length == 20;
    }

    public static boolean shouldBodyBeZero(int responseStatus) {
        return responseStatus == 204 || responseStatus == 304;
    }

    public static void addGzipHeader(HttpServletResponse response) throws GZipResponseException {
        response.setHeader("Content-Encoding", "gzip");
        boolean containsEncoding = response.containsHeader("Content-Encoding");
        if (!containsEncoding) {
            throw new GZipResponseException("Failure when attempting to set Content-Encoding: gzip");
        }
    }
}

