/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.web;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.stereotype.Component;

@Component
public class TomcatKeyringFix
implements WebServerFactoryCustomizer<TomcatServletWebServerFactory> {
    private static final Pattern KEYRING_PATTERN = Pattern.compile("^(safkeyring[^:]*):/{2,4}([^/]+)/(.+)$");
    private static final String KEYRING_PASSWORD = "password";
    @Value(value="${server.ssl.keyStore:#{null}}")
    protected String keyStore;
    @Value(value="${server.ssl.keyAlias:localhost}")
    protected String keyAlias;
    @Value(value="${server.ssl.keyStorePassword:#{null}}")
    protected char[] keyStorePassword;
    @Value(value="${server.ssl.keyPassword:#{null}}")
    protected char[] keyPassword;
    @Value(value="${server.ssl.trustStore:#{null}}")
    protected String trustStore;
    @Value(value="${server.ssl.trustStorePassword:#{null}}")
    protected char[] trustStorePassword;

    boolean isKeyring(String input) {
        if (input == null) {
            return false;
        }
        Matcher matcher = KEYRING_PATTERN.matcher(input);
        return matcher.matches();
    }

    static String formatKeyringUrl(String keyringUrl) {
        if (keyringUrl == null) {
            return null;
        }
        Matcher matcher = KEYRING_PATTERN.matcher((CharSequence)keyringUrl);
        if (matcher.matches()) {
            keyringUrl = matcher.group(1) + "://" + matcher.group(2) + "/" + matcher.group(3);
        }
        return keyringUrl;
    }

    public void customize(TomcatServletWebServerFactory factory) {
        Ssl ssl = factory.getSsl();
        if (this.isKeyring(this.keyStore)) {
            ssl.setKeyStore(TomcatKeyringFix.formatKeyringUrl(this.keyStore));
            ssl.setKeyAlias(this.keyAlias);
            ssl.setKeyStorePassword(this.keyStorePassword == null ? KEYRING_PASSWORD : String.valueOf(this.keyStorePassword));
            ssl.setKeyPassword(this.keyPassword == null ? KEYRING_PASSWORD : String.valueOf(this.keyPassword));
        }
        if (this.isKeyring(this.trustStore)) {
            ssl.setTrustStore(TomcatKeyringFix.formatKeyringUrl(this.trustStore));
            ssl.setTrustStorePassword(this.trustStorePassword == null ? KEYRING_PASSWORD : String.valueOf(this.trustStorePassword));
        }
    }
}

