/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.web;

import jakarta.annotation.PostConstruct;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.channels.SocketChannel;
import lombok.Generated;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.stereotype.Component;
import org.zowe.apiml.exception.AttlsHandlerException;
import org.zowe.commons.attls.ContextIsNotInitializedException;
import org.zowe.commons.attls.InboundAttls;

@Component
@ConditionalOnProperty(name={"server.attls.enabled"}, havingValue="true")
public class ApimlTomcatCustomizer<S, U>
implements WebServerFactoryCustomizer<TomcatServletWebServerFactory> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApimlTomcatCustomizer.class);

    @PostConstruct
    public void afterPropertiesSet() {
        log.debug("AT-TLS mode is enabled");
    }

    public void customize(TomcatServletWebServerFactory factory) {
        InboundAttls.setAlwaysLoadCertificate((boolean)true);
        factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{this::customizeConnector});
    }

    public void customizeConnector(Connector connector) {
        Http11NioProtocol protocolHandler = (Http11NioProtocol)connector.getProtocolHandler();
        try {
            Field handlerField = AbstractProtocol.class.getDeclaredField("handler");
            handlerField.setAccessible(true);
            ApimlAttlsHandler handler = (ApimlAttlsHandler)handlerField.get(protocolHandler);
            handler = new ApimlAttlsHandler(handler);
            Method method = AbstractProtocol.class.getDeclaredMethod("getEndpoint", new Class[0]);
            method.setAccessible(true);
            AbstractEndpoint abstractEndpoint = (AbstractEndpoint)method.invoke((Object)protocolHandler, new Object[0]);
            abstractEndpoint.setHandler(handler);
        }
        catch (Exception e) {
            throw new AttlsHandlerException("Not able to add handler.", e);
        }
    }

    public static class ApimlAttlsHandler<S>
    implements AbstractEndpoint.Handler<S> {
        private final AbstractEndpoint.Handler<S> handler;
        private final Field fdField;

        public ApimlAttlsHandler(AbstractEndpoint.Handler<S> handler) {
            this.handler = handler;
            try {
                Class<?> socketChannelImpl = Class.forName("sun.nio.ch.SocketChannelImpl");
                this.fdField = socketChannelImpl.getDeclaredField("fdVal");
                this.fdField.setAccessible(true);
            }
            catch (ClassNotFoundException | NoSuchFieldException e) {
                throw new IllegalArgumentException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public AbstractEndpoint.Handler.SocketState process(SocketWrapperBase<S> socket, SocketEvent status) {
            NioChannel secureChannel = (NioChannel)socket.getSocket();
            SocketChannel socketChannel = secureChannel.getIOChannel();
            try {
                int fileDescriptor = this.fdField.getInt(socketChannel);
                InboundAttls.init((int)fileDescriptor);
                AbstractEndpoint.Handler.SocketState socketState = this.handler.process(socket, status);
                return socketState;
            }
            catch (IllegalAccessException e) {
                throw new AttlsHandlerException("Different implementation expected.", e);
            }
            finally {
                try {
                    InboundAttls.clean();
                }
                catch (ContextIsNotInitializedException e) {
                    log.debug("Cannot clean AT-TLS context");
                }
                finally {
                    InboundAttls.dispose();
                }
            }
        }

        public Object getGlobal() {
            return this.handler.getGlobal();
        }

        public void release(SocketWrapperBase<S> socketWrapper) {
            this.handler.release(socketWrapper);
        }

        public void pause() {
            this.handler.pause();
        }

        public void recycle() {
            this.handler.recycle();
        }
    }
}

