/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.filter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.util.codec.binary.Base64;
import org.springframework.web.filter.OncePerRequestFilter;
import org.zowe.apiml.filter.AttlsErrorHandler;
import org.zowe.commons.attls.InboundAttls;

public class AttlsFilter
extends OncePerRequestFilter {
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            if (InboundAttls.getCertificate() != null && InboundAttls.getCertificate().length > 0) {
                this.populateRequestWithCertificate(request, InboundAttls.getCertificate());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Not possible to get certificate from AT-TLS context", (Throwable)e);
            AttlsErrorHandler.handleError(response, "Exception reading certificate");
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void populateRequestWithCertificate(HttpServletRequest request, byte[] rawCertificate) throws CertificateException {
        byte[] encodedCert = Base64.encodeBase64((byte[])rawCertificate);
        String s = new String(encodedCert);
        s = "-----BEGIN CERTIFICATE-----\n" + s + "\n-----END CERTIFICATE-----";
        X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(s.getBytes()));
        X509Certificate[] certificates = new X509Certificate[]{certificate};
        request.setAttribute("javax.servlet.request.X509Certificate", (Object)certificates);
    }
}

