/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.common.content;

import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.web.filter.OncePerRequestFilter;
import org.zowe.apiml.security.common.error.ResourceAccessExceptionHandler;

public abstract class AbstractSecureContentFilter
extends OncePerRequestFilter {
    private final AuthenticationManager authenticationManager;
    private final AuthenticationFailureHandler failureHandler;
    private final ResourceAccessExceptionHandler resourceAccessExceptionHandler;
    private final String[] endpoints;

    protected boolean shouldNotFilter(HttpServletRequest request) {
        if (this.endpoints == null || this.endpoints.length == 0) {
            return false;
        }
        String path = request.getServletPath();
        return Arrays.stream(this.endpoints).noneMatch(path::startsWith);
    }

    protected abstract Optional<AbstractAuthenticationToken> extractContent(HttpServletRequest var1);

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        Optional<AbstractAuthenticationToken> authenticationToken = this.extractContent(request);
        if (authenticationToken.isPresent()) {
            try {
                Authentication authentication = this.authenticationManager.authenticate((Authentication)authenticationToken.get());
                SecurityContextHolder.getContext().setAuthentication(authentication);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            catch (AuthenticationException authenticationException) {
                this.failureHandler.onAuthenticationFailure(request, response, authenticationException);
            }
            catch (RuntimeException e) {
                this.resourceAccessExceptionHandler.handleException(request, response, e);
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    @Generated
    public AbstractSecureContentFilter(AuthenticationManager authenticationManager, AuthenticationFailureHandler failureHandler, ResourceAccessExceptionHandler resourceAccessExceptionHandler, String[] endpoints) {
        this.authenticationManager = authenticationManager;
        this.failureHandler = failureHandler;
        this.resourceAccessExceptionHandler = resourceAccessExceptionHandler;
        this.endpoints = endpoints;
    }
}

