/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.common.auth.saf;

import java.util.Collections;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.zowe.apiml.security.common.auth.saf.EndpointImproprietyConfigureException;
import org.zowe.apiml.security.common.auth.saf.SafResourceAccessVerifying;
import org.zowe.apiml.security.common.auth.saf.UnsupportedResourceClassException;
import org.zowe.apiml.security.common.token.TokenAuthentication;

public class SafResourceAccessEndpoint
implements SafResourceAccessVerifying {
    private static final String URL_VARIABLE_SUFFIX = "/{entity}/{level}";
    @Value(value="${apiml.security.authorization.endpoint.url:http://localhost:8542/saf-auth}")
    private String endpointUrl;
    private final RestTemplate restTemplate;

    private <T> HttpEntity<T> createHttpEntity(Authentication authentication) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        if (authentication instanceof TokenAuthentication) {
            TokenAuthentication tokenAuthentication = (TokenAuthentication)authentication;
            headers.set("Cookie", "apimlAuthenticationToken=" + tokenAuthentication.getCredentials());
        }
        return new HttpEntity((MultiValueMap)headers);
    }

    @Override
    public boolean hasSafResourceAccess(Authentication authentication, String resourceClass, String resourceName, String accessLevel) {
        if (!StringUtils.equalsIgnoreCase((CharSequence)"ZOWE", (CharSequence)resourceClass)) {
            throw new UnsupportedResourceClassException(resourceClass, "The SAF provider `endpoint` supports only resource class 'ZOWE', but current one is '" + resourceClass + "'");
        }
        try {
            HttpEntity httpEntity = this.createHttpEntity(authentication);
            ResponseEntity responseEntity = this.restTemplate.exchange(this.endpointUrl + URL_VARIABLE_SUFFIX, HttpMethod.GET, httpEntity, Response.class, new Object[]{resourceName, accessLevel});
            Response response = (Response)responseEntity.getBody();
            if (response != null && response.isError()) {
                throw new EndpointImproprietyConfigureException("Endpoint " + this.endpointUrl + " is not properly configured: " + response.getMessage(), this.endpointUrl);
            }
            return response != null && !response.isError() && response.isAuthorized();
        }
        catch (EndpointImproprietyConfigureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EndpointImproprietyConfigureException("Endpoint " + this.endpointUrl + " is not properly configured.", this.endpointUrl, e);
        }
    }

    @Generated
    public SafResourceAccessEndpoint(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public static class Response {
        private boolean authorized;
        private boolean error;
        private String message;

        @Generated
        public boolean isAuthorized() {
            return this.authorized;
        }

        @Generated
        public boolean isError() {
            return this.error;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public void setAuthorized(boolean authorized) {
            this.authorized = authorized;
        }

        @Generated
        public void setError(boolean error) {
            this.error = error;
        }

        @Generated
        public void setMessage(String message) {
            this.message = message;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAuthorized() != other.isAuthorized()) {
                return false;
            }
            if (this.isError() != other.isError()) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAuthorized() ? 79 : 97);
            result = result * 59 + (this.isError() ? 79 : 97);
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SafResourceAccessEndpoint.Response(authorized=" + this.isAuthorized() + ", error=" + this.isError() + ", message=" + this.getMessage() + ")";
        }

        @Generated
        public Response(boolean authorized, boolean error, String message) {
            this.authorized = authorized;
            this.error = error;
            this.message = message;
        }

        @Generated
        public Response() {
        }
    }
}

