/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.common.config;

import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.stereotype.Component;
import org.zowe.apiml.auth.AuthenticationScheme;
import org.zowe.apiml.message.log.ApimlLogger;
import org.zowe.apiml.product.logging.annotations.InjectApimlLogger;

@Component
@ConfigurationProperties(prefix="apiml.security.auth", ignoreUnknownFields=false)
public class AuthConfigurationProperties {
    @InjectApimlLogger
    private ApimlLogger apimlLog = ApimlLogger.empty();
    private String gatewayLoginEndpoint = "/gateway/api/v1/auth/login";
    private String gatewayLogoutEndpoint = "/gateway/api/v1/auth/logout";
    private String gatewayQueryEndpoint = "/gateway/api/v1/auth/query";
    private String gatewayTicketEndpoint = "/gateway/api/v1/auth/ticket";
    private String gatewayLoginEndpointOldFormat = "/api/v1/gateway/auth/login";
    private String gatewayLogoutEndpointOldFormat = "/api/v1/gateway/auth/logout";
    private String gatewayQueryEndpointOldFormat = "/api/v1/gateway/auth/query";
    private String gatewayTicketEndpointOldFormat = "/api/v1/gateway/auth/ticket";
    private String serviceLoginEndpoint = "/auth/login";
    private String serviceLogoutEndpoint = "/auth/logout";
    private TokenProperties tokenProperties;
    private CookieProperties cookieProperties;
    private String zosmfServiceId;
    private String provider = "zosmf";
    private PassTicket passTicket;
    private String jwtKeyAlias;
    private String zosmfJwtEndpoint = "/jwt/ibm/api/zOSMFBuilder/jwk";
    private JWT_AUTOCONFIGURATION_MODE zosmfJwtAutoconfiguration = JWT_AUTOCONFIGURATION_MODE.AUTO;

    public AuthConfigurationProperties() {
        this.cookieProperties = new CookieProperties();
        this.tokenProperties = new TokenProperties();
        this.passTicket = new PassTicket();
    }

    public String validatedZosmfServiceId() {
        if (this.provider.equalsIgnoreCase(AuthenticationScheme.ZOSMF.getScheme()) && (this.zosmfServiceId == null || this.zosmfServiceId.isEmpty())) {
            this.apimlLog.log("org.zowe.apiml.security.zosmfNotFound", new Object[0]);
            throw new AuthenticationServiceException("The parameter 'zosmfServiceId' is not configured.");
        }
        return this.zosmfServiceId;
    }

    @Generated
    public ApimlLogger getApimlLog() {
        return this.apimlLog;
    }

    @Generated
    public String getGatewayLoginEndpoint() {
        return this.gatewayLoginEndpoint;
    }

    @Generated
    public String getGatewayLogoutEndpoint() {
        return this.gatewayLogoutEndpoint;
    }

    @Generated
    public String getGatewayQueryEndpoint() {
        return this.gatewayQueryEndpoint;
    }

    @Generated
    public String getGatewayTicketEndpoint() {
        return this.gatewayTicketEndpoint;
    }

    @Generated
    public String getGatewayLoginEndpointOldFormat() {
        return this.gatewayLoginEndpointOldFormat;
    }

    @Generated
    public String getGatewayLogoutEndpointOldFormat() {
        return this.gatewayLogoutEndpointOldFormat;
    }

    @Generated
    public String getGatewayQueryEndpointOldFormat() {
        return this.gatewayQueryEndpointOldFormat;
    }

    @Generated
    public String getGatewayTicketEndpointOldFormat() {
        return this.gatewayTicketEndpointOldFormat;
    }

    @Generated
    public String getServiceLoginEndpoint() {
        return this.serviceLoginEndpoint;
    }

    @Generated
    public String getServiceLogoutEndpoint() {
        return this.serviceLogoutEndpoint;
    }

    @Generated
    public TokenProperties getTokenProperties() {
        return this.tokenProperties;
    }

    @Generated
    public CookieProperties getCookieProperties() {
        return this.cookieProperties;
    }

    @Generated
    public String getZosmfServiceId() {
        return this.zosmfServiceId;
    }

    @Generated
    public String getProvider() {
        return this.provider;
    }

    @Generated
    public PassTicket getPassTicket() {
        return this.passTicket;
    }

    @Generated
    public String getJwtKeyAlias() {
        return this.jwtKeyAlias;
    }

    @Generated
    public String getZosmfJwtEndpoint() {
        return this.zosmfJwtEndpoint;
    }

    @Generated
    public JWT_AUTOCONFIGURATION_MODE getZosmfJwtAutoconfiguration() {
        return this.zosmfJwtAutoconfiguration;
    }

    @Generated
    public void setApimlLog(ApimlLogger apimlLog) {
        this.apimlLog = apimlLog;
    }

    @Generated
    public void setGatewayLoginEndpoint(String gatewayLoginEndpoint) {
        this.gatewayLoginEndpoint = gatewayLoginEndpoint;
    }

    @Generated
    public void setGatewayLogoutEndpoint(String gatewayLogoutEndpoint) {
        this.gatewayLogoutEndpoint = gatewayLogoutEndpoint;
    }

    @Generated
    public void setGatewayQueryEndpoint(String gatewayQueryEndpoint) {
        this.gatewayQueryEndpoint = gatewayQueryEndpoint;
    }

    @Generated
    public void setGatewayTicketEndpoint(String gatewayTicketEndpoint) {
        this.gatewayTicketEndpoint = gatewayTicketEndpoint;
    }

    @Generated
    public void setGatewayLoginEndpointOldFormat(String gatewayLoginEndpointOldFormat) {
        this.gatewayLoginEndpointOldFormat = gatewayLoginEndpointOldFormat;
    }

    @Generated
    public void setGatewayLogoutEndpointOldFormat(String gatewayLogoutEndpointOldFormat) {
        this.gatewayLogoutEndpointOldFormat = gatewayLogoutEndpointOldFormat;
    }

    @Generated
    public void setGatewayQueryEndpointOldFormat(String gatewayQueryEndpointOldFormat) {
        this.gatewayQueryEndpointOldFormat = gatewayQueryEndpointOldFormat;
    }

    @Generated
    public void setGatewayTicketEndpointOldFormat(String gatewayTicketEndpointOldFormat) {
        this.gatewayTicketEndpointOldFormat = gatewayTicketEndpointOldFormat;
    }

    @Generated
    public void setServiceLoginEndpoint(String serviceLoginEndpoint) {
        this.serviceLoginEndpoint = serviceLoginEndpoint;
    }

    @Generated
    public void setServiceLogoutEndpoint(String serviceLogoutEndpoint) {
        this.serviceLogoutEndpoint = serviceLogoutEndpoint;
    }

    @Generated
    public void setTokenProperties(TokenProperties tokenProperties) {
        this.tokenProperties = tokenProperties;
    }

    @Generated
    public void setCookieProperties(CookieProperties cookieProperties) {
        this.cookieProperties = cookieProperties;
    }

    @Generated
    public void setZosmfServiceId(String zosmfServiceId) {
        this.zosmfServiceId = zosmfServiceId;
    }

    @Generated
    public void setProvider(String provider) {
        this.provider = provider;
    }

    @Generated
    public void setPassTicket(PassTicket passTicket) {
        this.passTicket = passTicket;
    }

    @Generated
    public void setJwtKeyAlias(String jwtKeyAlias) {
        this.jwtKeyAlias = jwtKeyAlias;
    }

    @Generated
    public void setZosmfJwtEndpoint(String zosmfJwtEndpoint) {
        this.zosmfJwtEndpoint = zosmfJwtEndpoint;
    }

    @Generated
    public void setZosmfJwtAutoconfiguration(JWT_AUTOCONFIGURATION_MODE zosmfJwtAutoconfiguration) {
        this.zosmfJwtAutoconfiguration = zosmfJwtAutoconfiguration;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthConfigurationProperties)) {
            return false;
        }
        AuthConfigurationProperties other = (AuthConfigurationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ApimlLogger this$apimlLog = this.getApimlLog();
        ApimlLogger other$apimlLog = other.getApimlLog();
        if (this$apimlLog == null ? other$apimlLog != null : !this$apimlLog.equals(other$apimlLog)) {
            return false;
        }
        String this$gatewayLoginEndpoint = this.getGatewayLoginEndpoint();
        String other$gatewayLoginEndpoint = other.getGatewayLoginEndpoint();
        if (this$gatewayLoginEndpoint == null ? other$gatewayLoginEndpoint != null : !this$gatewayLoginEndpoint.equals(other$gatewayLoginEndpoint)) {
            return false;
        }
        String this$gatewayLogoutEndpoint = this.getGatewayLogoutEndpoint();
        String other$gatewayLogoutEndpoint = other.getGatewayLogoutEndpoint();
        if (this$gatewayLogoutEndpoint == null ? other$gatewayLogoutEndpoint != null : !this$gatewayLogoutEndpoint.equals(other$gatewayLogoutEndpoint)) {
            return false;
        }
        String this$gatewayQueryEndpoint = this.getGatewayQueryEndpoint();
        String other$gatewayQueryEndpoint = other.getGatewayQueryEndpoint();
        if (this$gatewayQueryEndpoint == null ? other$gatewayQueryEndpoint != null : !this$gatewayQueryEndpoint.equals(other$gatewayQueryEndpoint)) {
            return false;
        }
        String this$gatewayTicketEndpoint = this.getGatewayTicketEndpoint();
        String other$gatewayTicketEndpoint = other.getGatewayTicketEndpoint();
        if (this$gatewayTicketEndpoint == null ? other$gatewayTicketEndpoint != null : !this$gatewayTicketEndpoint.equals(other$gatewayTicketEndpoint)) {
            return false;
        }
        String this$gatewayLoginEndpointOldFormat = this.getGatewayLoginEndpointOldFormat();
        String other$gatewayLoginEndpointOldFormat = other.getGatewayLoginEndpointOldFormat();
        if (this$gatewayLoginEndpointOldFormat == null ? other$gatewayLoginEndpointOldFormat != null : !this$gatewayLoginEndpointOldFormat.equals(other$gatewayLoginEndpointOldFormat)) {
            return false;
        }
        String this$gatewayLogoutEndpointOldFormat = this.getGatewayLogoutEndpointOldFormat();
        String other$gatewayLogoutEndpointOldFormat = other.getGatewayLogoutEndpointOldFormat();
        if (this$gatewayLogoutEndpointOldFormat == null ? other$gatewayLogoutEndpointOldFormat != null : !this$gatewayLogoutEndpointOldFormat.equals(other$gatewayLogoutEndpointOldFormat)) {
            return false;
        }
        String this$gatewayQueryEndpointOldFormat = this.getGatewayQueryEndpointOldFormat();
        String other$gatewayQueryEndpointOldFormat = other.getGatewayQueryEndpointOldFormat();
        if (this$gatewayQueryEndpointOldFormat == null ? other$gatewayQueryEndpointOldFormat != null : !this$gatewayQueryEndpointOldFormat.equals(other$gatewayQueryEndpointOldFormat)) {
            return false;
        }
        String this$gatewayTicketEndpointOldFormat = this.getGatewayTicketEndpointOldFormat();
        String other$gatewayTicketEndpointOldFormat = other.getGatewayTicketEndpointOldFormat();
        if (this$gatewayTicketEndpointOldFormat == null ? other$gatewayTicketEndpointOldFormat != null : !this$gatewayTicketEndpointOldFormat.equals(other$gatewayTicketEndpointOldFormat)) {
            return false;
        }
        String this$serviceLoginEndpoint = this.getServiceLoginEndpoint();
        String other$serviceLoginEndpoint = other.getServiceLoginEndpoint();
        if (this$serviceLoginEndpoint == null ? other$serviceLoginEndpoint != null : !this$serviceLoginEndpoint.equals(other$serviceLoginEndpoint)) {
            return false;
        }
        String this$serviceLogoutEndpoint = this.getServiceLogoutEndpoint();
        String other$serviceLogoutEndpoint = other.getServiceLogoutEndpoint();
        if (this$serviceLogoutEndpoint == null ? other$serviceLogoutEndpoint != null : !this$serviceLogoutEndpoint.equals(other$serviceLogoutEndpoint)) {
            return false;
        }
        TokenProperties this$tokenProperties = this.getTokenProperties();
        TokenProperties other$tokenProperties = other.getTokenProperties();
        if (this$tokenProperties == null ? other$tokenProperties != null : !((Object)this$tokenProperties).equals(other$tokenProperties)) {
            return false;
        }
        CookieProperties this$cookieProperties = this.getCookieProperties();
        CookieProperties other$cookieProperties = other.getCookieProperties();
        if (this$cookieProperties == null ? other$cookieProperties != null : !((Object)this$cookieProperties).equals(other$cookieProperties)) {
            return false;
        }
        String this$zosmfServiceId = this.getZosmfServiceId();
        String other$zosmfServiceId = other.getZosmfServiceId();
        if (this$zosmfServiceId == null ? other$zosmfServiceId != null : !this$zosmfServiceId.equals(other$zosmfServiceId)) {
            return false;
        }
        String this$provider = this.getProvider();
        String other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        PassTicket this$passTicket = this.getPassTicket();
        PassTicket other$passTicket = other.getPassTicket();
        if (this$passTicket == null ? other$passTicket != null : !((Object)this$passTicket).equals(other$passTicket)) {
            return false;
        }
        String this$jwtKeyAlias = this.getJwtKeyAlias();
        String other$jwtKeyAlias = other.getJwtKeyAlias();
        if (this$jwtKeyAlias == null ? other$jwtKeyAlias != null : !this$jwtKeyAlias.equals(other$jwtKeyAlias)) {
            return false;
        }
        String this$zosmfJwtEndpoint = this.getZosmfJwtEndpoint();
        String other$zosmfJwtEndpoint = other.getZosmfJwtEndpoint();
        if (this$zosmfJwtEndpoint == null ? other$zosmfJwtEndpoint != null : !this$zosmfJwtEndpoint.equals(other$zosmfJwtEndpoint)) {
            return false;
        }
        JWT_AUTOCONFIGURATION_MODE this$zosmfJwtAutoconfiguration = this.getZosmfJwtAutoconfiguration();
        JWT_AUTOCONFIGURATION_MODE other$zosmfJwtAutoconfiguration = other.getZosmfJwtAutoconfiguration();
        return !(this$zosmfJwtAutoconfiguration == null ? other$zosmfJwtAutoconfiguration != null : !((Object)((Object)this$zosmfJwtAutoconfiguration)).equals((Object)other$zosmfJwtAutoconfiguration));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthConfigurationProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApimlLogger $apimlLog = this.getApimlLog();
        result = result * 59 + ($apimlLog == null ? 43 : $apimlLog.hashCode());
        String $gatewayLoginEndpoint = this.getGatewayLoginEndpoint();
        result = result * 59 + ($gatewayLoginEndpoint == null ? 43 : $gatewayLoginEndpoint.hashCode());
        String $gatewayLogoutEndpoint = this.getGatewayLogoutEndpoint();
        result = result * 59 + ($gatewayLogoutEndpoint == null ? 43 : $gatewayLogoutEndpoint.hashCode());
        String $gatewayQueryEndpoint = this.getGatewayQueryEndpoint();
        result = result * 59 + ($gatewayQueryEndpoint == null ? 43 : $gatewayQueryEndpoint.hashCode());
        String $gatewayTicketEndpoint = this.getGatewayTicketEndpoint();
        result = result * 59 + ($gatewayTicketEndpoint == null ? 43 : $gatewayTicketEndpoint.hashCode());
        String $gatewayLoginEndpointOldFormat = this.getGatewayLoginEndpointOldFormat();
        result = result * 59 + ($gatewayLoginEndpointOldFormat == null ? 43 : $gatewayLoginEndpointOldFormat.hashCode());
        String $gatewayLogoutEndpointOldFormat = this.getGatewayLogoutEndpointOldFormat();
        result = result * 59 + ($gatewayLogoutEndpointOldFormat == null ? 43 : $gatewayLogoutEndpointOldFormat.hashCode());
        String $gatewayQueryEndpointOldFormat = this.getGatewayQueryEndpointOldFormat();
        result = result * 59 + ($gatewayQueryEndpointOldFormat == null ? 43 : $gatewayQueryEndpointOldFormat.hashCode());
        String $gatewayTicketEndpointOldFormat = this.getGatewayTicketEndpointOldFormat();
        result = result * 59 + ($gatewayTicketEndpointOldFormat == null ? 43 : $gatewayTicketEndpointOldFormat.hashCode());
        String $serviceLoginEndpoint = this.getServiceLoginEndpoint();
        result = result * 59 + ($serviceLoginEndpoint == null ? 43 : $serviceLoginEndpoint.hashCode());
        String $serviceLogoutEndpoint = this.getServiceLogoutEndpoint();
        result = result * 59 + ($serviceLogoutEndpoint == null ? 43 : $serviceLogoutEndpoint.hashCode());
        TokenProperties $tokenProperties = this.getTokenProperties();
        result = result * 59 + ($tokenProperties == null ? 43 : ((Object)$tokenProperties).hashCode());
        CookieProperties $cookieProperties = this.getCookieProperties();
        result = result * 59 + ($cookieProperties == null ? 43 : ((Object)$cookieProperties).hashCode());
        String $zosmfServiceId = this.getZosmfServiceId();
        result = result * 59 + ($zosmfServiceId == null ? 43 : $zosmfServiceId.hashCode());
        String $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        PassTicket $passTicket = this.getPassTicket();
        result = result * 59 + ($passTicket == null ? 43 : ((Object)$passTicket).hashCode());
        String $jwtKeyAlias = this.getJwtKeyAlias();
        result = result * 59 + ($jwtKeyAlias == null ? 43 : $jwtKeyAlias.hashCode());
        String $zosmfJwtEndpoint = this.getZosmfJwtEndpoint();
        result = result * 59 + ($zosmfJwtEndpoint == null ? 43 : $zosmfJwtEndpoint.hashCode());
        JWT_AUTOCONFIGURATION_MODE $zosmfJwtAutoconfiguration = this.getZosmfJwtAutoconfiguration();
        result = result * 59 + ($zosmfJwtAutoconfiguration == null ? 43 : ((Object)((Object)$zosmfJwtAutoconfiguration)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthConfigurationProperties(apimlLog=" + this.getApimlLog() + ", gatewayLoginEndpoint=" + this.getGatewayLoginEndpoint() + ", gatewayLogoutEndpoint=" + this.getGatewayLogoutEndpoint() + ", gatewayQueryEndpoint=" + this.getGatewayQueryEndpoint() + ", gatewayTicketEndpoint=" + this.getGatewayTicketEndpoint() + ", gatewayLoginEndpointOldFormat=" + this.getGatewayLoginEndpointOldFormat() + ", gatewayLogoutEndpointOldFormat=" + this.getGatewayLogoutEndpointOldFormat() + ", gatewayQueryEndpointOldFormat=" + this.getGatewayQueryEndpointOldFormat() + ", gatewayTicketEndpointOldFormat=" + this.getGatewayTicketEndpointOldFormat() + ", serviceLoginEndpoint=" + this.getServiceLoginEndpoint() + ", serviceLogoutEndpoint=" + this.getServiceLogoutEndpoint() + ", tokenProperties=" + this.getTokenProperties() + ", cookieProperties=" + this.getCookieProperties() + ", zosmfServiceId=" + this.getZosmfServiceId() + ", provider=" + this.getProvider() + ", passTicket=" + this.getPassTicket() + ", jwtKeyAlias=" + this.getJwtKeyAlias() + ", zosmfJwtEndpoint=" + this.getZosmfJwtEndpoint() + ", zosmfJwtAutoconfiguration=" + (Object)((Object)this.getZosmfJwtAutoconfiguration()) + ")";
    }

    public static class PassTicket {
        private Integer timeout = 540;

        @Generated
        public PassTicket() {
        }

        @Generated
        public Integer getTimeout() {
            return this.timeout;
        }

        @Generated
        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PassTicket)) {
                return false;
            }
            PassTicket other = (PassTicket)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$timeout = this.getTimeout();
            Integer other$timeout = other.getTimeout();
            return !(this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PassTicket;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $timeout = this.getTimeout();
            result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AuthConfigurationProperties.PassTicket(timeout=" + this.getTimeout() + ")";
        }
    }

    public static class CookieProperties {
        private String cookieName = "apimlAuthenticationToken";
        private boolean cookieSecure = true;
        private String cookiePath = "/";
        private String cookieComment = "API Mediation Layer security token";
        private Integer cookieMaxAge = -1;

        @Generated
        public CookieProperties() {
        }

        @Generated
        public String getCookieName() {
            return this.cookieName;
        }

        @Generated
        public boolean isCookieSecure() {
            return this.cookieSecure;
        }

        @Generated
        public String getCookiePath() {
            return this.cookiePath;
        }

        @Generated
        public String getCookieComment() {
            return this.cookieComment;
        }

        @Generated
        public Integer getCookieMaxAge() {
            return this.cookieMaxAge;
        }

        @Generated
        public void setCookieName(String cookieName) {
            this.cookieName = cookieName;
        }

        @Generated
        public void setCookieSecure(boolean cookieSecure) {
            this.cookieSecure = cookieSecure;
        }

        @Generated
        public void setCookiePath(String cookiePath) {
            this.cookiePath = cookiePath;
        }

        @Generated
        public void setCookieComment(String cookieComment) {
            this.cookieComment = cookieComment;
        }

        @Generated
        public void setCookieMaxAge(Integer cookieMaxAge) {
            this.cookieMaxAge = cookieMaxAge;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CookieProperties)) {
                return false;
            }
            CookieProperties other = (CookieProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isCookieSecure() != other.isCookieSecure()) {
                return false;
            }
            Integer this$cookieMaxAge = this.getCookieMaxAge();
            Integer other$cookieMaxAge = other.getCookieMaxAge();
            if (this$cookieMaxAge == null ? other$cookieMaxAge != null : !((Object)this$cookieMaxAge).equals(other$cookieMaxAge)) {
                return false;
            }
            String this$cookieName = this.getCookieName();
            String other$cookieName = other.getCookieName();
            if (this$cookieName == null ? other$cookieName != null : !this$cookieName.equals(other$cookieName)) {
                return false;
            }
            String this$cookiePath = this.getCookiePath();
            String other$cookiePath = other.getCookiePath();
            if (this$cookiePath == null ? other$cookiePath != null : !this$cookiePath.equals(other$cookiePath)) {
                return false;
            }
            String this$cookieComment = this.getCookieComment();
            String other$cookieComment = other.getCookieComment();
            return !(this$cookieComment == null ? other$cookieComment != null : !this$cookieComment.equals(other$cookieComment));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CookieProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCookieSecure() ? 79 : 97);
            Integer $cookieMaxAge = this.getCookieMaxAge();
            result = result * 59 + ($cookieMaxAge == null ? 43 : ((Object)$cookieMaxAge).hashCode());
            String $cookieName = this.getCookieName();
            result = result * 59 + ($cookieName == null ? 43 : $cookieName.hashCode());
            String $cookiePath = this.getCookiePath();
            result = result * 59 + ($cookiePath == null ? 43 : $cookiePath.hashCode());
            String $cookieComment = this.getCookieComment();
            result = result * 59 + ($cookieComment == null ? 43 : $cookieComment.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AuthConfigurationProperties.CookieProperties(cookieName=" + this.getCookieName() + ", cookieSecure=" + this.isCookieSecure() + ", cookiePath=" + this.getCookiePath() + ", cookieComment=" + this.getCookieComment() + ", cookieMaxAge=" + this.getCookieMaxAge() + ")";
        }
    }

    public static class TokenProperties {
        private int expirationInSeconds = 28800;
        private String issuer = "APIML";
        private String shortTtlUsername = "expire";
        private long shortTtlExpirationInSeconds = 1L;

        @Generated
        public TokenProperties() {
        }

        @Generated
        public int getExpirationInSeconds() {
            return this.expirationInSeconds;
        }

        @Generated
        public String getIssuer() {
            return this.issuer;
        }

        @Generated
        public String getShortTtlUsername() {
            return this.shortTtlUsername;
        }

        @Generated
        public long getShortTtlExpirationInSeconds() {
            return this.shortTtlExpirationInSeconds;
        }

        @Generated
        public void setExpirationInSeconds(int expirationInSeconds) {
            this.expirationInSeconds = expirationInSeconds;
        }

        @Generated
        public void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Generated
        public void setShortTtlUsername(String shortTtlUsername) {
            this.shortTtlUsername = shortTtlUsername;
        }

        @Generated
        public void setShortTtlExpirationInSeconds(long shortTtlExpirationInSeconds) {
            this.shortTtlExpirationInSeconds = shortTtlExpirationInSeconds;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TokenProperties)) {
                return false;
            }
            TokenProperties other = (TokenProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getExpirationInSeconds() != other.getExpirationInSeconds()) {
                return false;
            }
            if (this.getShortTtlExpirationInSeconds() != other.getShortTtlExpirationInSeconds()) {
                return false;
            }
            String this$issuer = this.getIssuer();
            String other$issuer = other.getIssuer();
            if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
                return false;
            }
            String this$shortTtlUsername = this.getShortTtlUsername();
            String other$shortTtlUsername = other.getShortTtlUsername();
            return !(this$shortTtlUsername == null ? other$shortTtlUsername != null : !this$shortTtlUsername.equals(other$shortTtlUsername));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TokenProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getExpirationInSeconds();
            long $shortTtlExpirationInSeconds = this.getShortTtlExpirationInSeconds();
            result = result * 59 + (int)($shortTtlExpirationInSeconds >>> 32 ^ $shortTtlExpirationInSeconds);
            String $issuer = this.getIssuer();
            result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
            String $shortTtlUsername = this.getShortTtlUsername();
            result = result * 59 + ($shortTtlUsername == null ? 43 : $shortTtlUsername.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AuthConfigurationProperties.TokenProperties(expirationInSeconds=" + this.getExpirationInSeconds() + ", issuer=" + this.getIssuer() + ", shortTtlUsername=" + this.getShortTtlUsername() + ", shortTtlExpirationInSeconds=" + this.getShortTtlExpirationInSeconds() + ")";
        }
    }

    public static enum JWT_AUTOCONFIGURATION_MODE {
        AUTO,
        LTPA,
        JWT;

    }
}

