/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.common.auth.saf;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.zowe.apiml.security.common.auth.saf.AccessControlError;
import org.zowe.apiml.security.common.auth.saf.AccessLevel;
import org.zowe.apiml.security.common.auth.saf.PlatformAckErrno;
import org.zowe.apiml.security.common.auth.saf.PlatformErrno2;
import org.zowe.apiml.security.common.auth.saf.PlatformReturned;
import org.zowe.apiml.security.common.auth.saf.PlatformReturnedHelper;
import org.zowe.apiml.security.common.auth.saf.SafResourceAccessVerifying;

public class SafResourceAccessSaf
implements SafResourceAccessVerifying {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SafResourceAccessSaf.class);
    private static final String PLATFORM_ACCESS_CONTROL_CLASS_NAME = "com.ibm.os390.security.PlatformAccessControl";
    private static final String PLATFORM_PLATFORM_CLASS_NAME = "com.ibm.os390.security.PlatformReturned";
    private static final String CHECK_PERMISSION_METHOD_NAME = "checkPermission";
    private PlatformReturnedHelper<Object> platformReturnedHelper;
    private MethodHandle checkPermission;

    public SafResourceAccessSaf() throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException, IllegalAccessException {
        this.init();
    }

    protected Class<?> getPlatformClass() throws ClassNotFoundException {
        return Class.forName(PLATFORM_ACCESS_CONTROL_CLASS_NAME);
    }

    protected Class<?> getPlatformReturnedClass() throws ClassNotFoundException {
        return Class.forName(PLATFORM_PLATFORM_CLASS_NAME);
    }

    protected MethodHandle getCheckPermissionMethodHandle(Class<?> clazz) throws IllegalAccessException, NoSuchMethodException {
        Method method = clazz.getDeclaredMethod(CHECK_PERMISSION_METHOD_NAME, String.class, String.class, String.class, Integer.TYPE);
        return MethodHandles.lookup().unreflect(method);
    }

    private void init() throws ClassNotFoundException, IllegalAccessException, NoSuchMethodException, NoSuchFieldException {
        this.platformReturnedHelper = new PlatformReturnedHelper(this.getPlatformReturnedClass());
        this.checkPermission = this.getCheckPermissionMethodHandle(this.getPlatformClass());
    }

    private boolean evaluatePlatformReturned(PlatformReturned returned, boolean resourceHasToExist) {
        String message;
        if (returned == null) {
            return true;
        }
        PlatformAckErrno errno = PlatformAckErrno.valueOfErrno(returned.getErrno());
        PlatformErrno2 errno2 = PlatformErrno2.valueOfErrno(returned.getErrno2());
        if (errno == null || errno2 == null) {
            message = "Unknown access control error";
            log.error("Platform access control failed: {}", (Object)returned);
        } else {
            message = "Platform access control failed: " + errno2.explanation;
            switch (errno2) {
                case JRSAFResourceUndefined: {
                    return !resourceHasToExist;
                }
                case JRSAFNoUser: 
                case JRNoResourceAccess: {
                    return false;
                }
            }
            log.error("Platform access control failed: {} {} {} {}", new Object[]{errno.shortErrorName, errno2.shortErrorName, errno2.explanation, returned});
        }
        throw new AccessControlError(returned, message + ": " + returned.toString());
    }

    private PlatformReturned checkPermission(String userId, String resourceType, String resourceName, int accessLevel) {
        try {
            Object platformReturned = this.checkPermission.invokeWithArguments(userId, resourceType, resourceName, accessLevel);
            return this.platformReturnedHelper.convert(platformReturned);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }

    private boolean checkPermission(String userId, String resourceType, String resourceName, int accessLevel, boolean resourceHasToExist) {
        PlatformReturned platformReturned = this.checkPermission(userId, resourceType, resourceName, accessLevel);
        return this.evaluatePlatformReturned(platformReturned, resourceHasToExist);
    }

    @Override
    public boolean hasSafResourceAccess(Authentication authentication, String resourceClass, String resourceName, String accessLevel) {
        String userid = authentication.getName();
        AccessLevel level = AccessLevel.valueOf(accessLevel);
        log.debug("Evaluating access of user {} to resource {} in class {} level {}", new Object[]{userid, resourceClass, resourceName, level});
        return this.checkPermission(userid, resourceClass, resourceName, level.getValue(), true);
    }
}

