/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.common.auth.saf;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.yaml.snakeyaml.Yaml;
import org.zowe.apiml.security.common.auth.saf.AccessLevel;
import org.zowe.apiml.security.common.auth.saf.SafResourceAccessVerifying;

public class SafResourceAccessDummy
implements SafResourceAccessVerifying {
    private static final String SAF_ACCESS = "safAccess";
    private static final String DEFAULT_FILE_LOCATION = "saf.yml";
    private static final String DEFAULT_RESOURCE_LOCATION = "mock-saf.yml";
    private Map<ResourceUser, AccessLevel> resourceUserToAccessLevel;

    public SafResourceAccessDummy() throws IOException {
        block37: {
            this.resourceUserToAccessLevel = new HashMap<ResourceUser, AccessLevel>();
            File file = this.getFile();
            if (file.exists()) {
                try (FileInputStream fis = new FileInputStream(file);
                     BufferedInputStream bis = new BufferedInputStream(fis);){
                    this.loadDefinition(bis);
                    break block37;
                }
            }
            try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_RESOURCE_LOCATION);){
                this.loadDefinition(inputStream);
            }
        }
    }

    protected File getFile() {
        return new File(DEFAULT_FILE_LOCATION);
    }

    public SafResourceAccessDummy(InputStream inputStream) {
        this.resourceUserToAccessLevel = new HashMap<ResourceUser, AccessLevel>();
        this.loadDefinition(inputStream);
    }

    @Override
    public boolean hasSafResourceAccess(Authentication authentication, String resourceClass, String resourceName, String accessLevel) {
        ResourceUser resourceUser = ResourceUser.builder().resourceClass(resourceClass).resourceName(resourceName).userId(authentication.getName()).build();
        AccessLevel currentLevel = this.resourceUserToAccessLevel.get(resourceUser);
        if (currentLevel == null) {
            return false;
        }
        return currentLevel.compareTo(AccessLevel.valueOf(accessLevel)) >= 0;
    }

    private void loadDefinition(InputStream inputStream) {
        Yaml yaml = new Yaml();
        Map data = (Map)yaml.load(inputStream);
        this.loadDefinition(data);
    }

    private void set(ResourceUser resourceUser, AccessLevel accessLevel) {
        AccessLevel currentLevel = this.resourceUserToAccessLevel.get(resourceUser);
        if (currentLevel == null || currentLevel.compareTo(accessLevel) < 0) {
            currentLevel = accessLevel;
        }
        this.resourceUserToAccessLevel.put(resourceUser, currentLevel);
    }

    private void set(String resourceClass, String resourceName, List<String> users, String levelName) {
        AccessLevel accessLevel = AccessLevel.valueOf(levelName);
        for (String userId : users) {
            ResourceUser resourceUser = ResourceUser.builder().resourceClass(resourceClass).resourceName(resourceName).userId(userId).build();
            this.set(resourceUser, accessLevel);
        }
    }

    private <T> T getSafAccess(Map<String, Object> data) {
        if (data == null) {
            return null;
        }
        return (T)data.get(SAF_ACCESS);
    }

    private void loadDefinition(Map<String, Object> data) {
        Map classes = (Map)this.getSafAccess(data);
        if (classes == null) {
            return;
        }
        for (Map.Entry clazz : classes.entrySet()) {
            String resourceClass = (String)clazz.getKey();
            for (Map.Entry resource : ((Map)clazz.getValue()).entrySet()) {
                String resourceName = (String)resource.getKey();
                for (Map.Entry level : ((Map)resource.getValue()).entrySet()) {
                    String levelName = ((String)level.getKey()).toUpperCase();
                    List users = (List)level.getValue();
                    this.set(resourceClass, resourceName, users, levelName);
                }
            }
        }
    }

    private static final class ResourceUser {
        private final String resourceClass;
        private final String resourceName;
        private final String userId;

        @Generated
        ResourceUser(String resourceClass, String resourceName, String userId) {
            this.resourceClass = resourceClass;
            this.resourceName = resourceName;
            this.userId = userId;
        }

        @Generated
        public static ResourceUserBuilder builder() {
            return new ResourceUserBuilder();
        }

        @Generated
        public String getResourceClass() {
            return this.resourceClass;
        }

        @Generated
        public String getResourceName() {
            return this.resourceName;
        }

        @Generated
        public String getUserId() {
            return this.userId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResourceUser)) {
                return false;
            }
            ResourceUser other = (ResourceUser)o;
            String this$resourceClass = this.getResourceClass();
            String other$resourceClass = other.getResourceClass();
            if (this$resourceClass == null ? other$resourceClass != null : !this$resourceClass.equals(other$resourceClass)) {
                return false;
            }
            String this$resourceName = this.getResourceName();
            String other$resourceName = other.getResourceName();
            if (this$resourceName == null ? other$resourceName != null : !this$resourceName.equals(other$resourceName)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            return !(this$userId == null ? other$userId != null : !this$userId.equals(other$userId));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $resourceClass = this.getResourceClass();
            result = result * 59 + ($resourceClass == null ? 43 : $resourceClass.hashCode());
            String $resourceName = this.getResourceName();
            result = result * 59 + ($resourceName == null ? 43 : $resourceName.hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SafResourceAccessDummy.ResourceUser(resourceClass=" + this.getResourceClass() + ", resourceName=" + this.getResourceName() + ", userId=" + this.getUserId() + ")";
        }

        @Generated
        public static class ResourceUserBuilder {
            @Generated
            private String resourceClass;
            @Generated
            private String resourceName;
            @Generated
            private String userId;

            @Generated
            ResourceUserBuilder() {
            }

            @Generated
            public ResourceUserBuilder resourceClass(String resourceClass) {
                this.resourceClass = resourceClass;
                return this;
            }

            @Generated
            public ResourceUserBuilder resourceName(String resourceName) {
                this.resourceName = resourceName;
                return this;
            }

            @Generated
            public ResourceUserBuilder userId(String userId) {
                this.userId = userId;
                return this;
            }

            @Generated
            public ResourceUser build() {
                return new ResourceUser(this.resourceClass, this.resourceName, this.userId);
            }

            @Generated
            public String toString() {
                return "SafResourceAccessDummy.ResourceUser.ResourceUserBuilder(resourceClass=" + this.resourceClass + ", resourceName=" + this.resourceName + ", userId=" + this.userId + ")";
            }
        }
    }
}

