/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.gateway;

import com.netflix.appinfo.InstanceInfo;
import java.net.URI;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.zowe.apiml.message.log.ApimlLogger;
import org.zowe.apiml.product.constants.CoreService;
import org.zowe.apiml.product.gateway.GatewayClient;
import org.zowe.apiml.product.gateway.GatewayLookupCompleteEvent;
import org.zowe.apiml.product.instance.InstanceInitializationException;
import org.zowe.apiml.product.instance.ServiceAddress;
import org.zowe.apiml.product.instance.lookup.InstanceLookupExecutor;
import org.zowe.apiml.product.logging.annotations.InjectApimlLogger;

public class GatewayInstanceInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GatewayInstanceInitializer.class);
    private final InstanceLookupExecutor instanceLookupExecutor;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final GatewayClient gatewayClient;
    @InjectApimlLogger
    private final ApimlLogger apimlLog = ApimlLogger.empty();

    private ServiceAddress process(InstanceInfo instanceInfo) {
        try {
            String gatewayHomePage = instanceInfo.getHomePageUrl();
            URI uri = new URI(gatewayHomePage);
            log.debug("Gateway homePageUrl: " + gatewayHomePage);
            return ServiceAddress.builder().scheme(uri.getScheme()).hostname(uri.getHost() + ":" + uri.getPort()).build();
        }
        catch (Exception e) {
            throw new InstanceInitializationException(e.getMessage());
        }
    }

    @EventListener(value={HeartbeatEvent.class, ApplicationReadyEvent.class})
    public void init() {
        log.debug("GatewayInstanceInitializer starting asynchronous initialization of Gateway configuration");
        this.instanceLookupExecutor.run(CoreService.GATEWAY.getServiceId(), instance -> {
            ServiceAddress foundGatewayConfigProperties = this.process((InstanceInfo)instance);
            log.debug("GatewayInstanceInitializer has been initialized with Gateway instance on url: {}://{}", (Object)foundGatewayConfigProperties.getScheme(), (Object)foundGatewayConfigProperties.getHostname());
            this.gatewayClient.setGatewayConfigProperties(foundGatewayConfigProperties);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new GatewayLookupCompleteEvent(this));
        }, (exception, isStopped) -> {
            if (Boolean.TRUE.equals(isStopped)) {
                this.apimlLog.log("org.zowe.apiml.common.gatewayInstanceInitializerStopped", new Object[]{exception.getMessage()});
            }
        });
    }

    @Generated
    public GatewayInstanceInitializer(InstanceLookupExecutor instanceLookupExecutor, ApplicationEventPublisher applicationEventPublisher, GatewayClient gatewayClient) {
        this.instanceLookupExecutor = instanceLookupExecutor;
        this.applicationEventPublisher = applicationEventPublisher;
        this.gatewayClient = gatewayClient;
    }
}

