/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.config;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.catalina.connector.Connector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatReactiveWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.AbstractConfigurableWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Order(value=0x7FFFFFFF)
@Configuration
public class ServerAddressPropertiesUpdater
implements EnvironmentPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServerAddressPropertiesUpdater.class);
    private static final String ADDITIONAL_SUFFIX = ".additional";
    private static final Map<Integer, List<String>> ADDITIONAL_NETWORKS = new HashMap<Integer, List<String>>();
    private static String webApplicationType;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties readProperties() {
        Properties properties = new Properties();
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("META-INF/spring.factories");){
            if (is == null) {
                log.debug("META-INF/spring.factories file was not found.");
                Properties properties2 = properties;
                return properties2;
            }
            properties.load(is);
            return properties;
        }
        catch (Exception e) {
            log.error("Cannot read Tomcat connector configuration", (Throwable)e);
        }
        return properties;
    }

    private void splitProperty(ConfigurableEnvironment environment, Map<String, Object> overriddenProperties, String addressKey, String portKey, boolean basePort) {
        String addressValue = environment.getProperty(addressKey);
        if (addressValue == null) {
            return;
        }
        List<String> addresses = Arrays.asList(addressValue.split(",")).stream().map(String::trim).toList();
        if (basePort) {
            overriddenProperties.putIfAbsent(addressKey, addresses.get(0));
            addresses = addresses.subList(1, addresses.size());
            overriddenProperties.putIfAbsent(addressKey + ADDITIONAL_SUFFIX, StringUtils.join(addresses, (String)","));
        }
        if (!addresses.isEmpty()) {
            int port = Integer.parseInt(environment.getProperty(portKey));
            ADDITIONAL_NETWORKS.put(port, addresses);
        }
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        webApplicationType = environment.getProperty("spring.main.web-application-type");
        try {
            String prefix;
            HashMap<String, Object> overriddenProperties = new HashMap<String, Object>();
            Properties config = this.readProperties();
            int i = 0;
            while (config.containsKey((prefix = this.getClass().getName() + ".connector." + i + ".") + "portKey")) {
                this.splitProperty(environment, overriddenProperties, (String)config.get(prefix + "addressKey"), (String)config.get(prefix + "portKey"), Boolean.valueOf((String)config.get(prefix + "main")));
                ++i;
            }
            if (!overriddenProperties.isEmpty()) {
                environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("override", overriddenProperties));
            }
        }
        catch (RuntimeException e) {
            log.error("Cannot open additional Tomcat connectors", (Throwable)e);
            throw e;
        }
    }

    @Bean
    public BeanDefinitionRegistryPostProcessor registerAdditionalTomcatConnectors() {
        if (ADDITIONAL_NETWORKS.isEmpty()) {
            return registry -> {};
        }
        Class connectorCustomizerClass = "servlet".equalsIgnoreCase(webApplicationType) ? AdditionalConnectorServlet.class : AdditionalConnectorReactive.class;
        return registry -> {
            for (Map.Entry<Integer, List<String>> entry : ADDITIONAL_NETWORKS.entrySet()) {
                int port = entry.getKey();
                ListIterator<String> li = entry.getValue().listIterator();
                while (li.hasNext()) {
                    String address = li.next();
                    String beanName = "tomcatAdditionalConnector-" + port + "-" + li.nextIndex();
                    AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition((Class)connectorCustomizerClass).addPropertyValue("port", (Object)port).addPropertyValue("address", (Object)address).getBeanDefinition();
                    registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
                }
            }
        };
    }

    static class AdditionalConnectorServlet
    extends AbstractAdditionalConnector<TomcatServletWebServerFactory> {
        public AdditionalConnectorServlet(List<TomcatConnectorCustomizer> connectorCustomizers) {
            super(connectorCustomizers);
        }

        @Override
        protected void initFactory(TomcatServletWebServerFactory factory) {
            factory.addAdditionalTomcatConnectors(new Connector[]{this.connector});
            factory.addConnectorCustomizers(this.connectorCustomizers.toArray(new TomcatConnectorCustomizer[0]));
        }
    }

    static class AdditionalConnectorReactive
    extends AbstractAdditionalConnector<TomcatReactiveWebServerFactory> {
        public AdditionalConnectorReactive(List<TomcatConnectorCustomizer> connectorCustomizers) {
            super(connectorCustomizers);
        }

        @Override
        protected void initFactory(TomcatReactiveWebServerFactory factory) {
            factory.addAdditionalTomcatConnectors(new Connector[]{this.connector});
            factory.addConnectorCustomizers(this.connectorCustomizers.toArray(new TomcatConnectorCustomizer[0]));
        }
    }

    static abstract class AbstractAdditionalConnector<F extends AbstractConfigurableWebServerFactory>
    implements WebServerFactoryCustomizer<F> {
        protected final List<TomcatConnectorCustomizer> connectorCustomizers;
        protected int port;
        protected String address;
        protected Connector connector = new Connector();

        private void invokeCustomizer(F factory, Class<? super F> factoryClass, Connector connector) {
            Exception exception;
            try {
                Method method = factoryClass.getDeclaredMethod("customizeConnector", Connector.class);
                method.setAccessible(true);
                method.invoke(factory, connector);
                return;
            }
            catch (NoSuchMethodException e) {
                if (factoryClass != Object.class) {
                    this.invokeCustomizer(factory, factoryClass.getSuperclass(), connector);
                    return;
                }
                exception = e;
            }
            catch (IllegalAccessException | SecurityException | InvocationTargetException e) {
                exception = e;
            }
            log.error("Cannot create the custom Tomcat reactive connector with address {} on port {}: {}", new Object[]{this.address, this.port, exception.getMessage()});
            throw new RuntimeException(exception);
        }

        public void customize(F factory) {
            this.invokeCustomizer(factory, factory.getClass(), this.connector);
            this.connector.setPort(this.port);
            if (this.address != null) {
                this.connector.setProperty("address", this.address);
            }
            this.initFactory(factory);
        }

        protected abstract void initFactory(F var1);

        @Generated
        public AbstractAdditionalConnector(List<TomcatConnectorCustomizer> connectorCustomizers) {
            this.connectorCustomizers = connectorCustomizers;
        }

        @Generated
        public void setPort(int port) {
            this.port = port;
        }

        @Generated
        public void setAddress(String address) {
            this.address = address;
        }
    }
}

