/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.instance.lookup;

import com.netflix.appinfo.InstanceInfo;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.netflix.eureka.EurekaServiceInstance;
import org.zowe.apiml.constants.EurekaMetadataDefinition;
import org.zowe.apiml.product.instance.InstanceNotFoundException;
import org.zowe.apiml.product.instance.lookup.RetryException;

public class InstanceLookupExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstanceLookupExecutor.class);
    private final DiscoveryClient discoveryClient;

    private InstanceInfo findEurekaInstance(String serviceId) {
        block3: {
            block2: {
                List services = this.discoveryClient.getServices();
                if (StringUtils.isEmpty((CharSequence)serviceId)) break block2;
                if (!services.stream().noneMatch(serviceId::equalsIgnoreCase)) break block3;
            }
            throw new InstanceNotFoundException("Service '" + serviceId + "' is not registered to Discovery Service");
        }
        List instances = this.discoveryClient.getInstances(serviceId);
        return instances.stream().filter(EurekaServiceInstance.class::isInstance).map(EurekaServiceInstance.class::cast).map(EurekaServiceInstance::getInstanceInfo).filter(instanceInfo -> EurekaMetadataDefinition.RegistrationType.of((Map)instanceInfo.getMetadata()).isPrimary()).findFirst().orElseThrow(() -> new InstanceNotFoundException("'" + serviceId + "' has no running instances registered to Discovery Service"));
    }

    public void run(String serviceId, Consumer<InstanceInfo> action, BiConsumer<Exception, Boolean> handleFailureConsumer) {
        log.debug("Started instance finder");
        try {
            InstanceInfo instanceInfo = this.findEurekaInstance(serviceId);
            log.debug("App found {}", (Object)instanceInfo.getAppName());
            action.accept(instanceInfo);
        }
        catch (InstanceNotFoundException | RetryException e) {
            log.debug(e.getMessage());
            handleFailureConsumer.accept(e, false);
        }
        catch (Exception e) {
            handleFailureConsumer.accept(e, true);
            log.debug("Unexpected exception while retrieving '{}' service from Eureka", (Object)serviceId, (Object)e);
        }
    }

    @Generated
    public InstanceLookupExecutor(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }
}

