/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.BasicHttpEntity;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.OngoingStubbing;

public class HttpClientMockHelper {
    public static OngoingStubbing<?> whenExecuteThenThrow(CloseableHttpClient httpClientMock, Exception exception) {
        return Mockito.when((Object)httpClientMock.execute((ClassicHttpRequest)ArgumentMatchers.any(ClassicHttpRequest.class), (HttpClientResponseHandler)ArgumentMatchers.any(HttpClientResponseHandler.class))).thenThrow(new Throwable[]{exception});
    }

    public static OngoingStubbing<?> mockExecuteWithResponse(CloseableHttpClient httpClientMock, ClassicHttpResponse responseMock) {
        return Mockito.when((Object)httpClientMock.execute((ClassicHttpRequest)ArgumentMatchers.any(ClassicHttpRequest.class), (HttpClientResponseHandler)ArgumentMatchers.any(HttpClientResponseHandler.class))).thenAnswer(invocation -> HttpClientMockHelper.invokeResponseHandler(invocation, responseMock));
    }

    public static <T> T invokeResponseHandler(InvocationOnMock invocation, ClassicHttpResponse responseMock) {
        HttpClientResponseHandler handler = (HttpClientResponseHandler)invocation.getArguments()[1];
        return (T)handler.handleResponse(responseMock);
    }

    public static void mockResponse(ClassicHttpResponse responseMock, int statusCode, String responseBody) {
        HttpClientMockHelper.mockResponse(responseMock, statusCode);
        HttpClientMockHelper.mockResponse(responseMock, responseBody);
    }

    public static void mockResponse(ClassicHttpResponse responseMock, String responseBody) {
        BasicHttpEntity responseEntity = responseBody == null ? null : new BasicHttpEntity(IOUtils.toInputStream((String)responseBody, (Charset)StandardCharsets.UTF_8), ContentType.APPLICATION_JSON);
        Mockito.when((Object)responseMock.getEntity()).thenReturn((Object)responseEntity);
    }

    public static void mockResponse(ClassicHttpResponse responseMock, int statusCode) {
        Mockito.when((Object)responseMock.getCode()).thenReturn((Object)statusCode);
    }
}

