/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.web;

import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClient;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClientImpl;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import org.zowe.apiml.message.log.ApimlLogger;
import org.zowe.apiml.product.logging.annotations.InjectApimlLogger;
import org.zowe.apiml.security.HttpsConfig;
import org.zowe.apiml.security.HttpsConfigError;
import org.zowe.apiml.security.HttpsFactory;
import org.zowe.apiml.security.SecurityUtils;

@Configuration
public class HttpConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpConfig.class);
    @Value(value="${server.ssl.protocol:TLSv1.2}")
    private String protocol;
    @Value(value="${server.ssl.trustStore:#{null}}")
    private String trustStore;
    @Value(value="${server.ssl.trustStorePassword:#{null}}")
    private String trustStorePassword;
    @Value(value="${server.ssl.trustStoreType:PKCS12}")
    private String trustStoreType;
    @Value(value="${server.ssl.keyAlias:#{null}}")
    private String keyAlias;
    @Value(value="${server.ssl.keyStore:#{null}}")
    private String keyStore;
    @Value(value="${server.ssl.keyStorePassword:#{null}}")
    private String keyStorePassword;
    @Value(value="${server.ssl.keyPassword:#{null}}")
    private String keyPassword;
    @Value(value="${server.ssl.keyStoreType:PKCS12}")
    private String keyStoreType;
    @Value(value="${apiml.security.ssl.verifySslCertificatesOfServices:true}")
    private boolean verifySslCertificatesOfServices;
    @Value(value="${spring.application.name}")
    private String serviceId;
    @Value(value="${server.ssl.trustStoreRequired:false}")
    private boolean trustStoreRequired;
    @Value(value="${eureka.client.serviceUrl.defaultZone}")
    private String eurekaServerUrl;
    private CloseableHttpClient secureHttpClient;
    private CloseableHttpClient secureHttpClientWithoutKeystore;
    private SSLContext secureSslContext;
    private HostnameVerifier secureHostnameVerifier;
    private EurekaJerseyClientImpl.EurekaJerseyClientBuilder eurekaJerseyClientBuilder;
    @InjectApimlLogger
    private ApimlLogger apimlLog = ApimlLogger.empty();

    @PostConstruct
    public void init() {
        try {
            Supplier<HttpsConfig.HttpsConfigBuilder> httpsConfigSupplier = () -> HttpsConfig.builder().protocol(this.protocol).trustStore(this.trustStore).trustStoreType(this.trustStoreType).trustStorePassword(this.trustStorePassword).trustStoreRequired(this.trustStoreRequired).verifySslCertificatesOfServices(this.verifySslCertificatesOfServices);
            HttpsConfig httpsConfig = httpsConfigSupplier.get().keyAlias(this.keyAlias).keyStore(this.keyStore).keyPassword(this.keyPassword).keyStorePassword(this.keyStorePassword).keyStoreType(this.keyStoreType).trustStore(this.trustStore).build();
            HttpsConfig httpsConfigWithoutKeystore = httpsConfigSupplier.get().build();
            log.info("Using HTTPS configuration: {}", (Object)httpsConfig.toString());
            HttpsFactory factory = new HttpsFactory(httpsConfig);
            this.secureHttpClient = factory.createSecureHttpClient();
            this.secureSslContext = factory.createSslContext();
            this.secureHostnameVerifier = factory.createHostnameVerifier();
            this.eurekaJerseyClientBuilder = factory.createEurekaJerseyClientBuilder(this.eurekaServerUrl, this.serviceId);
            HttpsFactory factoryWithoutKeystore = new HttpsFactory(httpsConfigWithoutKeystore);
            this.secureHttpClientWithoutKeystore = factoryWithoutKeystore.createSecureHttpClient();
            factory.setSystemSslProperties();
        }
        catch (HttpsConfigError e) {
            System.exit(1);
        }
        catch (Exception e) {
            this.apimlLog.log("org.zowe.apiml.common.unknownHttpsConfigError", new Object[]{e.getMessage()});
            System.exit(1);
        }
    }

    @Bean
    public SslContextFactory jettySslContextFactory() {
        SslContextFactory sslContextFactory = new SslContextFactory(SecurityUtils.replaceFourSlashes((String)this.keyStore));
        sslContextFactory.setProtocol(this.protocol);
        sslContextFactory.setKeyStorePassword(this.keyStorePassword);
        sslContextFactory.setKeyStoreType(this.keyStoreType);
        sslContextFactory.setCertAlias(this.keyAlias);
        if (this.trustStore != null) {
            sslContextFactory.setTrustStorePath(SecurityUtils.replaceFourSlashes((String)this.trustStore));
            sslContextFactory.setTrustStoreType(this.trustStoreType);
            sslContextFactory.setTrustStorePassword(this.trustStorePassword);
        }
        log.debug("jettySslContextFactory: {}", (Object)sslContextFactory.dump());
        if (!this.verifySslCertificatesOfServices) {
            sslContextFactory.setTrustAll(true);
        }
        return sslContextFactory;
    }

    @Bean
    @Primary
    @Qualifier(value="restTemplateWithKeystore")
    public RestTemplate restTemplateWithKeystore() {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)this.secureHttpClient);
        return new RestTemplate((ClientHttpRequestFactory)factory);
    }

    @Bean
    public RestTemplate restTemplateWithoutKeystore() {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)this.secureHttpClientWithoutKeystore);
        return new RestTemplate((ClientHttpRequestFactory)factory);
    }

    @Bean
    @Primary
    public CloseableHttpClient secureHttpClient() {
        return this.secureHttpClient;
    }

    @Bean
    @Qualifier(value="secureHttpClientWithoutKeystore")
    public CloseableHttpClient secureHttpClientWithoutKeystore() {
        return this.secureHttpClientWithoutKeystore;
    }

    @Bean
    public SSLContext secureSslContext() {
        return this.secureSslContext;
    }

    @Bean
    public HostnameVerifier secureHostnameVerifier() {
        return this.secureHostnameVerifier;
    }

    @Bean
    public EurekaJerseyClient eurekaJerseyClient() {
        return this.eurekaJerseyClientBuilder.build();
    }
}

