/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.routing.transform;

import java.net.URI;
import lombok.Generated;
import org.zowe.apiml.message.log.ApimlLogger;
import org.zowe.apiml.product.gateway.GatewayClient;
import org.zowe.apiml.product.gateway.GatewayConfigProperties;
import org.zowe.apiml.product.logging.annotations.InjectApimlLogger;
import org.zowe.apiml.product.routing.RoutedService;
import org.zowe.apiml.product.routing.RoutedServices;
import org.zowe.apiml.product.routing.ServiceType;
import org.zowe.apiml.product.routing.transform.URLTransformationException;
import org.zowe.apiml.util.UrlUtils;

public class TransformService {
    private static final String SEPARATOR = "/";
    private final GatewayClient gatewayClient;
    @InjectApimlLogger
    private ApimlLogger apimlLog = ApimlLogger.empty();

    public String transformURL(ServiceType type, String serviceId, String serviceUrl, RoutedServices routes) throws URLTransformationException {
        String endPoint;
        if (!this.gatewayClient.isInitialized()) {
            this.apimlLog.log("org.zowe.apiml.common.gatewayNotFoundForTransformRequest", new Object[0]);
            throw new URLTransformationException("Gateway not found yet, transform service cannot perform the request");
        }
        URI serviceUri = URI.create(serviceUrl);
        String serviceUriPath = serviceUri.getPath();
        if (serviceUriPath == null) {
            String message = String.format("The URI %s is not valid.", serviceUri);
            throw new URLTransformationException(message);
        }
        RoutedService route = routes.getBestMatchingServiceUrl(serviceUriPath, type);
        if (route == null) {
            String message = String.format("Not able to select route for url %s of the service %s. Original url used.", serviceUri, serviceId);
            throw new URLTransformationException(message);
        }
        if (serviceUri.getQuery() != null) {
            serviceUriPath = serviceUriPath + "?" + serviceUri.getQuery();
        }
        if (!(endPoint = this.getShortEndPoint(route.getServiceUrl(), serviceUriPath)).isEmpty() && !endPoint.startsWith(SEPARATOR)) {
            throw new URLTransformationException("The path " + serviceUri.getPath() + " of the service URL " + serviceUri + " is not valid.");
        }
        GatewayConfigProperties gatewayConfigProperties = this.gatewayClient.getGatewayConfigProperties();
        return String.format("%s://%s/%s/%s%s", gatewayConfigProperties.getScheme(), gatewayConfigProperties.getHostname(), serviceId, route.getGatewayUrl(), endPoint);
    }

    private String getShortEndPoint(String routeServiceUrl, String endPoint) {
        String shortEndPoint = endPoint;
        if (!routeServiceUrl.equals(SEPARATOR)) {
            shortEndPoint = shortEndPoint.replaceFirst(UrlUtils.removeLastSlash((String)routeServiceUrl), "");
        }
        return shortEndPoint;
    }

    @Generated
    public TransformService(GatewayClient gatewayClient) {
        this.gatewayClient = gatewayClient;
    }
}

