/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery.config;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.eureka.DefaultEurekaServerContext;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerContext;
import com.netflix.eureka.EurekaServerContextHolder;
import com.netflix.eureka.cluster.PeerEurekaNodes;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.resources.ServerCodecs;
import com.netflix.eureka.transport.EurekaServerHttpClientFactory;
import com.netflix.eureka.util.EurekaMonitors;
import jakarta.ws.rs.client.ClientRequestFilter;
import java.util.Collection;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.netflix.eureka.server.InstanceRegistryProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.zowe.apiml.discovery.ApimlInstanceRegistry;
import org.zowe.apiml.discovery.eureka.RefreshablePeerEurekaNodes;

@Configuration
public class EurekaConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EurekaConfig.class);
    @Value(value="${apiml.discovery.serviceIdPrefixReplacer:#{null}}")
    private String tuple;
    @Value(value="${apiml.discovery.maxPeerRetries:10}")
    private int maxPeerRetries;

    @Bean
    @Primary
    public ApimlInstanceRegistry apimlInstanceRegistry(EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, ServerCodecs serverCodecs, EurekaClient eurekaClient, EurekaServerHttpClientFactory eurekaServerHttpClientFactory, InstanceRegistryProperties instanceRegistryProperties, ApplicationContext appCntx, Collection<ClientRequestFilter> replicationClientAdditionalFilters, @Qualifier(value="secureSslContext") SSLContext secureSslContext) {
        eurekaClient.getApplications();
        ApimlInstanceRegistry apimlInstanceRegistry = new ApimlInstanceRegistry(serverConfig, clientConfig, serverCodecs, eurekaClient, eurekaServerHttpClientFactory, instanceRegistryProperties, appCntx, new Tuple(this.tuple));
        ApplicationInfoManager applicationInfoManager = eurekaClient.getApplicationInfoManager();
        RefreshablePeerEurekaNodes peerEurekaNodes = new RefreshablePeerEurekaNodes((PeerAwareInstanceRegistry)apimlInstanceRegistry, serverConfig, clientConfig, serverCodecs, applicationInfoManager, replicationClientAdditionalFilters, secureSslContext, this.maxPeerRetries);
        DefaultEurekaServerContext serverContext = new DefaultEurekaServerContext(serverConfig, serverCodecs, (PeerAwareInstanceRegistry)apimlInstanceRegistry, (PeerEurekaNodes)peerEurekaNodes, applicationInfoManager);
        EurekaServerContextHolder.initialize((EurekaServerContext)serverContext);
        serverContext.initialize();
        log.info("Initialized server context");
        EurekaMonitors.registerAllStats();
        return apimlInstanceRegistry;
    }

    @Bean
    @Primary
    @DependsOn(value={"apimlInstanceRegistry"})
    public PeerEurekaNodes peerEurekaNodes() {
        return EurekaServerContextHolder.getInstance().getServerContext().getPeerEurekaNodes();
    }

    public static class Tuple {
        boolean valid;
        String oldPrefix;
        String newPrefix;

        public Tuple(String tuple) {
            if (Tuple.isValidTuple(tuple)) {
                String[] prefixes = tuple.split(",");
                this.oldPrefix = prefixes[0];
                this.newPrefix = prefixes[1];
                this.valid = true;
            }
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getOldPrefix() {
            return this.oldPrefix;
        }

        public String getNewPrefix() {
            return this.newPrefix;
        }

        public static boolean isValidTuple(String tuple) {
            if (StringUtils.isNotEmpty((CharSequence)tuple)) {
                String[] replacer = tuple.split(",");
                return replacer.length > 1 && StringUtils.isNotEmpty((CharSequence)replacer[0]) && StringUtils.isNotEmpty((CharSequence)replacer[1]) && !replacer[0].equals(replacer[1]);
            }
            return false;
        }
    }
}

