/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery.config;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.context.annotation.Primary;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Primary
@Controller
@RequestMapping(value={"${server.error.path:${error.path:/error}}"})
public class DiscoveryErrorController
extends BasicErrorController {
    public DiscoveryErrorController(ErrorAttributes errorAttributes, ServerProperties serverProperties, List<ErrorViewResolver> errorViewResolvers) {
        super(errorAttributes, serverProperties.getError(), errorViewResolvers);
    }

    @RequestMapping
    public ResponseEntity<Map<String, Object>> error(HttpServletRequest request) {
        HttpStatus status = this.getStatus(request);
        String originalUrl = String.valueOf(request.getAttribute("jakarta.servlet.error.request_uri"));
        if (status == HttpStatus.NOT_FOUND && StringUtils.startsWith((CharSequence)originalUrl, (CharSequence)"/eureka/apps/")) {
            return new ResponseEntity((HttpStatusCode)status);
        }
        return super.error(request);
    }
}

