/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery;

import com.netflix.appinfo.InstanceInfo;
import java.util.Map;
import lombok.Generated;
import org.springframework.cloud.netflix.eureka.server.event.EurekaInstanceRegisteredEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.zowe.apiml.discovery.metadata.MetadataDefaultsService;
import org.zowe.apiml.discovery.metadata.MetadataTranslationService;
import org.zowe.apiml.util.EurekaUtils;

@Component
public class EurekaInstanceRegisteredListener {
    private final MetadataTranslationService metadataTranslationService;
    private final MetadataDefaultsService metadataDefaultsService;

    @EventListener
    public void listen(EurekaInstanceRegisteredEvent event) {
        InstanceInfo instanceInfo = event.getInstanceInfo();
        Map metadata = instanceInfo.getMetadata();
        String serviceId = EurekaUtils.getServiceIdFromInstanceId((String)instanceInfo.getInstanceId());
        this.metadataTranslationService.translateMetadata(serviceId, metadata);
        this.metadataDefaultsService.updateMetadata(serviceId, metadata);
    }

    @Generated
    public EurekaInstanceRegisteredListener(MetadataTranslationService metadataTranslationService, MetadataDefaultsService metadataDefaultsService) {
        this.metadataTranslationService = metadataTranslationService;
        this.metadataDefaultsService = metadataDefaultsService;
    }
}

