/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery.eureka;

import com.netflix.appinfo.AbstractEurekaIdentity;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.converters.wrappers.CodecWrapper;
import com.netflix.discovery.converters.wrappers.DecoderWrapper;
import com.netflix.discovery.converters.wrappers.EncoderWrapper;
import com.netflix.discovery.provider.DiscoveryJerseyProvider;
import com.netflix.discovery.shared.transport.jersey3.EurekaIdentityHeaderFilter;
import com.netflix.discovery.shared.transport.jersey3.EurekaJersey3Client;
import com.netflix.discovery.shared.transport.jersey3.EurekaJersey3ClientImpl;
import com.netflix.discovery.util.DiscoveryBuildInfo;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerIdentity;
import com.netflix.eureka.cluster.HttpReplicationClient;
import com.netflix.eureka.cluster.PeerEurekaNode;
import com.netflix.eureka.cluster.PeerEurekaNodes;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.resources.ServerCodecs;
import com.netflix.eureka.transport.Jersey3DynamicGZIPContentEncodingFilter;
import com.netflix.eureka.transport.Jersey3ReplicationClient;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientRequestFilter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationListener;
import org.zowe.apiml.product.eureka.client.ApimlPeerEurekaNode;

public class RefreshablePeerEurekaNodes
extends PeerEurekaNodes
implements ApplicationListener<EnvironmentChangeEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RefreshablePeerEurekaNodes.class);
    private static final String USER_AGENT = "Java-EurekaClient-Replication";
    private Collection<ClientRequestFilter> replicationClientAdditionalFilters;
    private SSLContext secureSslContext;
    private int maxPeerRetries;

    public RefreshablePeerEurekaNodes(PeerAwareInstanceRegistry registry, EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, ServerCodecs serverCodecs, ApplicationInfoManager applicationInfoManager, Collection<ClientRequestFilter> replicationClientAdditionalFilters, @Qualifier(value="secureSslContext") SSLContext secureSslContext, int maxPeerRetries) {
        super(registry, serverConfig, clientConfig, serverCodecs, applicationInfoManager);
        this.replicationClientAdditionalFilters = replicationClientAdditionalFilters;
        this.secureSslContext = secureSslContext;
        this.maxPeerRetries = maxPeerRetries;
    }

    public PeerEurekaNode createPeerEurekaNode(String peerEurekaNodeUrl) {
        Jersey3ReplicationClient replicationClient = this.createReplicationClient(this.serverConfig, this.serverCodecs, peerEurekaNodeUrl, this.replicationClientAdditionalFilters);
        String targetHost = RefreshablePeerEurekaNodes.hostFromUrl((String)peerEurekaNodeUrl);
        if (targetHost == null) {
            targetHost = "host";
        }
        return new ApimlPeerEurekaNode(this.registry, targetHost, peerEurekaNodeUrl, (HttpReplicationClient)replicationClient, this.serverConfig, this.maxPeerRetries);
    }

    private Jersey3ReplicationClient createReplicationClient(EurekaServerConfig config, ServerCodecs serverCodecs, String serviceUrl, Collection<ClientRequestFilter> additionalFilters) {
        EurekaJersey3Client jerseyClient;
        String name = Jersey3ReplicationClient.class.getSimpleName() + ": " + serviceUrl + "apps/: ";
        try {
            String hostname;
            try {
                hostname = new URL(serviceUrl).getHost();
            }
            catch (MalformedURLException e) {
                hostname = serviceUrl;
            }
            String jerseyClientName = "Discovery-PeerNodeClient-" + hostname;
            CodecWrapper fullJsonCodec = serverCodecs.getFullJsonCodec();
            EurekaJersey3ClientImpl.EurekaJersey3ClientBuilder clientBuilder = new CustomEurekaJersey3ClientBuilder(fullJsonCodec, config).withClientName(jerseyClientName).withUserAgent(USER_AGENT).withEncoderWrapper((EncoderWrapper)fullJsonCodec).withDecoderWrapper((DecoderWrapper)fullJsonCodec).withConnectionTimeout(config.getPeerNodeConnectTimeoutMs()).withReadTimeout(config.getPeerNodeReadTimeoutMs()).withMaxConnectionsPerHost(config.getPeerNodeTotalConnectionsPerHost()).withMaxTotalConnections(config.getPeerNodeTotalConnections()).withConnectionIdleTimeout(config.getPeerNodeConnectionIdleTimeoutSeconds());
            if (serviceUrl.startsWith("https://") && "true".equals(System.getProperty("com.netflix.eureka.shouldSSLConnectionsUseSystemSocketFactory"))) {
                clientBuilder.withSystemSSLConfiguration();
            }
            jerseyClient = clientBuilder.build();
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot Create new Replica Node :" + name, e);
        }
        String ip = null;
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.warn("Cannot find localhost ip", (Throwable)e);
        }
        Client jerseyApacheClient = jerseyClient.getClient();
        jerseyApacheClient.register((Object)new Jersey3DynamicGZIPContentEncodingFilter(config));
        for (ClientRequestFilter filter : additionalFilters) {
            jerseyApacheClient.register((Object)filter);
        }
        EurekaServerIdentity identity = new EurekaServerIdentity(ip);
        jerseyApacheClient.register((Object)new EurekaIdentityHeaderFilter((AbstractEurekaIdentity)identity));
        return new Jersey3ReplicationClient(jerseyClient, serviceUrl);
    }

    public void onApplicationEvent(EnvironmentChangeEvent event) {
        if (this.shouldUpdate(event.getKeys())) {
            this.updatePeerEurekaNodes(this.resolvePeerUrls());
        }
    }

    protected boolean shouldUpdate(Set<String> changedKeys) {
        assert (changedKeys != null);
        if (this.clientConfig.shouldUseDnsForFetchingServiceUrls()) {
            return false;
        }
        if (changedKeys.contains("eureka.client.region")) {
            return true;
        }
        for (String key : changedKeys) {
            if (!key.startsWith("eureka.client.service-url.") && !key.startsWith("eureka.client.availability-zones.")) continue;
            return true;
        }
        return false;
    }

    class CustomEurekaJersey3ClientBuilder
    extends EurekaJersey3ClientImpl.EurekaJersey3ClientBuilder {
        private final CodecWrapper fullJsonCodec;
        private final EurekaServerConfig config;

        public CustomEurekaJersey3ClientBuilder(CodecWrapper fullJsonCodec, EurekaServerConfig config) {
            this.fullJsonCodec = fullJsonCodec;
            this.config = config;
        }

        public EurekaJersey3Client build() {
            try {
                return new EurekaJersey3ClientImpl(this.config.getPeerNodeConnectTimeoutMs(), this.config.getPeerNodeReadTimeoutMs(), this.config.getPeerNodeConnectionIdleTimeoutSeconds(), (ClientConfig)new CustomClientConfig(this.fullJsonCodec, this.config));
            }
            catch (Throwable e) {
                throw new RuntimeException("Cannot create Jersey client ", e);
            }
        }

        class CustomClientConfig
        extends ClientConfig {
            public CustomClientConfig(CodecWrapper fullJsonCodec, EurekaServerConfig config) {
                DiscoveryJerseyProvider discoveryJerseyProvider = new DiscoveryJerseyProvider((EncoderWrapper)fullJsonCodec, (DecoderWrapper)fullJsonCodec);
                this.register(discoveryJerseyProvider);
                SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(RefreshablePeerEurekaNodes.this.secureSslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                Registry registry = RegistryBuilder.create().register("https", (Object)socketFactory).build();
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
                cm.setDefaultMaxPerRoute(config.getPeerNodeTotalConnectionsPerHost());
                cm.setMaxTotal(config.getPeerNodeTotalConnections());
                this.property("jersey.config.apache.client.connectionManager", cm);
                String fullUserAgentName = "Java-EurekaClient-Replication/v" + DiscoveryBuildInfo.buildVersion();
                this.property("http.useragent", fullUserAgentName);
                this.property("jersey.config.client.followRedirects", Boolean.FALSE);
                this.property("http.protocol.handle-redirects", Boolean.FALSE);
            }
        }
    }
}

