/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery.eureka;

import com.netflix.appinfo.AbstractEurekaIdentity;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.converters.wrappers.DecoderWrapper;
import com.netflix.discovery.converters.wrappers.EncoderWrapper;
import com.netflix.discovery.shared.transport.jersey3.EurekaIdentityHeaderFilter;
import com.netflix.discovery.shared.transport.jersey3.EurekaJersey3Client;
import com.netflix.discovery.shared.transport.jersey3.EurekaJersey3ClientImpl;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerIdentity;
import com.netflix.eureka.cluster.HttpReplicationClient;
import com.netflix.eureka.cluster.PeerEurekaNode;
import com.netflix.eureka.cluster.PeerEurekaNodes;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.resources.ServerCodecs;
import com.netflix.eureka.transport.Jersey3DynamicGZIPContentEncodingFilter;
import com.netflix.eureka.transport.Jersey3ReplicationClient;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientRequestFilter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationListener;
import org.zowe.apiml.product.eureka.client.ApimlPeerEurekaNode;

public class RefreshablePeerEurekaNodes
extends PeerEurekaNodes
implements ApplicationListener<EnvironmentChangeEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RefreshablePeerEurekaNodes.class);
    private Collection<ClientRequestFilter> replicationClientAdditionalFilters;
    private int maxPeerRetries;

    public RefreshablePeerEurekaNodes(PeerAwareInstanceRegistry registry, EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, ServerCodecs serverCodecs, ApplicationInfoManager applicationInfoManager, Collection<ClientRequestFilter> replicationClientAdditionalFilters, int maxPeerRetries) {
        super(registry, serverConfig, clientConfig, serverCodecs, applicationInfoManager);
        this.replicationClientAdditionalFilters = replicationClientAdditionalFilters;
        this.maxPeerRetries = maxPeerRetries;
    }

    public PeerEurekaNode createPeerEurekaNode(String peerEurekaNodeUrl) {
        Jersey3ReplicationClient replicationClient = RefreshablePeerEurekaNodes.createReplicationClient(this.serverConfig, this.serverCodecs, peerEurekaNodeUrl, this.replicationClientAdditionalFilters);
        String targetHost = RefreshablePeerEurekaNodes.hostFromUrl((String)peerEurekaNodeUrl);
        if (targetHost == null) {
            targetHost = "host";
        }
        return new ApimlPeerEurekaNode(this.registry, targetHost, peerEurekaNodeUrl, (HttpReplicationClient)replicationClient, this.serverConfig, this.maxPeerRetries);
    }

    private static Jersey3ReplicationClient createReplicationClient(EurekaServerConfig config, ServerCodecs serverCodecs, String serviceUrl, Collection<ClientRequestFilter> additionalFilters) {
        EurekaJersey3Client jerseyClient;
        String name = Jersey3ReplicationClient.class.getSimpleName() + ": " + serviceUrl + "apps/: ";
        try {
            String hostname;
            try {
                hostname = new URL(serviceUrl).getHost();
            }
            catch (MalformedURLException e) {
                hostname = serviceUrl;
            }
            String jerseyClientName = "Discovery-PeerNodeClient-" + hostname;
            EurekaJersey3ClientImpl.EurekaJersey3ClientBuilder clientBuilder = new EurekaJersey3ClientImpl.EurekaJersey3ClientBuilder().withClientName(jerseyClientName).withUserAgent("Java-EurekaClient-Replication").withEncoderWrapper((EncoderWrapper)serverCodecs.getFullJsonCodec()).withDecoderWrapper((DecoderWrapper)serverCodecs.getFullJsonCodec()).withConnectionTimeout(config.getPeerNodeConnectTimeoutMs()).withReadTimeout(config.getPeerNodeReadTimeoutMs()).withMaxConnectionsPerHost(config.getPeerNodeTotalConnectionsPerHost()).withMaxTotalConnections(config.getPeerNodeTotalConnections()).withConnectionIdleTimeout(config.getPeerNodeConnectionIdleTimeoutSeconds());
            if (serviceUrl.startsWith("https://") && "true".equals(System.getProperty("com.netflix.eureka.shouldSSLConnectionsUseSystemSocketFactory"))) {
                clientBuilder.withSystemSSLConfiguration();
            }
            jerseyClient = clientBuilder.build();
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot Create new Replica Node :" + name, e);
        }
        String ip = null;
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.warn("Cannot find localhost ip", (Throwable)e);
        }
        Client jerseyApacheClient = jerseyClient.getClient();
        jerseyApacheClient.register((Object)new Jersey3DynamicGZIPContentEncodingFilter(config));
        for (ClientRequestFilter filter : additionalFilters) {
            jerseyApacheClient.register((Object)filter);
        }
        EurekaServerIdentity identity = new EurekaServerIdentity(ip);
        jerseyApacheClient.register((Object)new EurekaIdentityHeaderFilter((AbstractEurekaIdentity)identity));
        return new Jersey3ReplicationClient(jerseyClient, serviceUrl);
    }

    public void onApplicationEvent(EnvironmentChangeEvent event) {
        if (this.shouldUpdate(event.getKeys())) {
            this.updatePeerEurekaNodes(this.resolvePeerUrls());
        }
    }

    protected boolean shouldUpdate(Set<String> changedKeys) {
        assert (changedKeys != null);
        if (this.clientConfig.shouldUseDnsForFetchingServiceUrls()) {
            return false;
        }
        if (changedKeys.contains("eureka.client.region")) {
            return true;
        }
        for (String key : changedKeys) {
            if (!key.startsWith("eureka.client.service-url.") && !key.startsWith("eureka.client.availability-zones.")) continue;
            return true;
        }
        return false;
    }
}

